/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.CheckingMappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MappedBytes
extends AbstractBytes<Void> {
    public static boolean CHECKING = false;
    private final MappedFile mappedFile;

    protected MappedBytes(MappedFile mappedFile) throws IllegalStateException {
        this(mappedFile, "");
    }

    protected MappedBytes(MappedFile mappedFile, String name) throws IllegalStateException {
        super(NoBytesStore.noBytesStore(), NoBytesStore.noBytesStore().writePosition(), NoBytesStore.noBytesStore().writeLimit(), name);
        this.mappedFile = mappedFile;
        this.clear();
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull String filename, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(file, chunkSize, OS.pageSize());
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException, IllegalStateException {
        MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, false);
        return MappedBytes.mappedBytes(rw);
    }

    @NotNull
    public static MappedBytes mappedBytes(MappedFile rw) {
        return CHECKING ? new CheckingMappedBytes(rw) : new MappedBytes(rw);
    }

    public static MappedBytes readOnly(File file) throws FileNotFoundException {
        return new MappedBytes(MappedFile.readOnly(file));
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.mappedFile.setNewChunkListener(listener);
    }

    public MappedFile mappedFile() {
        return this.mappedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedBytes withSizes(long chunkSize, long overlapSize) {
        MappedFile mappedFile2 = this.mappedFile.withSizes(chunkSize, overlapSize);
        if (mappedFile2 == this.mappedFile) {
            return this;
        }
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(mappedFile2);
            return mappedBytes;
        }
        finally {
            this.release();
        }
    }

    @Override
    public BytesStore<Bytes<Void>, Void> copy() {
        return NativeBytes.copyOf(this);
    }

    @Override
    public long capacity() {
        return this.mappedFile == null ? 0L : this.mappedFile.capacity();
    }

    @Override
    public long realCapacity() {
        try {
            return this.mappedFile.actualSize();
        }
        catch (IORuntimeException e) {
            Jvm.warn().on(this.getClass(), "Unable to obtain the real size for " + this.mappedFile.file(), (Throwable)e);
            return 0L;
        }
    }

    @Override
    protected void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException {
        long check;
        long l = check = adding >= 0L ? offset : offset + adding;
        if (!this.bytesStore.inside(check)) {
            this.acquireNextByteStore(offset);
        }
        super.readCheckOffset(offset, adding, given);
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
        if (offset < 0L || offset > this.capacity() - adding) {
            throw new IllegalArgumentException("Offset out of bound " + offset);
        }
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset);
        }
        super.writeCheckOffset(offset, adding);
    }

    private void acquireNextByteStore(long offset) {
        BytesStore oldBS = this.bytesStore;
        try {
            this.bytesStore = this.mappedFile.acquireByteStore(offset);
            oldBS.release();
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.initCause(e);
            throw boe;
        }
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    protected void performRelease() {
        super.performRelease();
        this.mappedFile.close();
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NotNull BytesStore bytes, long offset, long length) throws BufferUnderflowException, BufferOverflowException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.isDirectMemory() && length >= 16L) {
            this.rawCopy(bytes, offset, length);
        } else {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    public void rawCopy(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
        if (len > 0L) {
            OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
            this.uncheckedWritePosition(this.writePosition() + len);
        }
    }

    @Override
    public Bytes<Void> append8bit(@NotNull CharSequence cs, int start, int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        return cs instanceof String ? this.append8bit0((String)cs, start, end - start) : (Bytes<Void>)super.append8bit(cs, start, end);
    }

    @Override
    public Bytes<Void> writeUtf8(String s) throws BufferOverflowException {
        char[] chars = StringUtils.extractChars((String)s);
        long utfLength = AppendableUtil.findUtf8Length(chars);
        this.writeStopBit(utfLength);
        this.appendUtf8(chars, 0, chars.length);
        return this;
    }

    @Override
    public MappedBytes write8bit(CharSequence s, int start, int length) {
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(s instanceof String) || pos + (long)length + 5L >= this.safeLimit()) {
            super.write8bit(s, start, length);
            return this;
        }
        this.writeStopBit(length);
        return this.append8bit0((String)s, start, length);
    }

    @NotNull
    private MappedBytes append8bit0(String s, int start, int length) {
        int i;
        char[] chars = StringUtils.extractChars((String)s);
        long address = this.address(this.writePosition());
        Memory memory = OS.memory();
        for (i = 0; i < length - 3; i += 4) {
            int c0 = chars[i + start] & 0xFF;
            int c1 = chars[i + start + 1] & 0xFF;
            int c2 = chars[i + start + 2] & 0xFF;
            int c3 = chars[i + start + 3] & 0xFF;
            memory.writeInt(address, c3 << 24 | c2 << 16 | c1 << 8 | c0);
            address += 4L;
        }
        while (i < length) {
            char c = chars[i + start];
            memory.writeByte(address++, (byte)c);
            ++i;
        }
        this.writeSkip(length);
        return this;
    }

    @Override
    public Bytes<Void> appendUtf8(CharSequence cs, int start, int length) throws BufferOverflowException, IllegalArgumentException {
        char c;
        int i;
        char[] chars;
        block4: {
            long pos = this.writePosition();
            this.writeCheckOffset(pos, 0L);
            if (!(cs instanceof String) || pos + (long)length + 5L >= this.safeLimit()) {
                super.appendUtf8(cs, start, length);
                return this;
            }
            chars = StringUtils.extractChars((String)((String)cs));
            long address = this.address(pos);
            Memory memory = OS.memory();
            for (i = 0; i < length; ++i) {
                c = chars[i + start];
                if (c > '\u007f') {
                    this.writeSkip(i);
                    break block4;
                }
                memory.writeByte(address++, (byte)c);
            }
            this.writeSkip(length);
            return this;
        }
        while (i < length) {
            c = chars[i + start];
            this.appendUtf8(c);
            ++i;
        }
        return this;
    }

    @Override
    public boolean sharedMemory() {
        return true;
    }

    @Override
    public Bytes<Void> writeOrderedInt(long offset, int i) throws BufferOverflowException {
        assert (this.writeCheckOffset0(offset, 4L));
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset);
        }
        ((NativeBytesStore)this.bytesStore).writeOrderedInt(offset, i);
        return this;
    }

    @Override
    public int peekVolatileInt() {
        if (!this.bytesStore.inside(this.readPosition)) {
            this.acquireNextByteStore(this.readPosition);
        }
        MappedBytesStore bytesStore = (MappedBytesStore)this.bytesStore;
        long address = bytesStore.address + bytesStore.translate(this.readPosition);
        Memory memory = bytesStore.memory;
        if ((address & 0x3FL) <= 60L) {
            if (memory == null) {
                throw new NullPointerException();
            }
            int value = UnsafeMemory.UNSAFE.getIntVolatile(null, address);
            if (value != 0 && value != Integer.MIN_VALUE) {
                return value;
            }
            return UnsafeMemory.UNSAFE.getIntVolatile(null, address);
        }
        return memory.readVolatileInt(address);
    }
}

