/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.CheckingMappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public class MappedBytes
extends AbstractBytes<Void> {
    public static boolean CHECKING = false;
    private final MappedFile mappedFile;

    protected MappedBytes(MappedFile mappedFile) throws IllegalStateException {
        super(NoBytesStore.noBytesStore(), NoBytesStore.noBytesStore().writePosition(), NoBytesStore.noBytesStore().writeLimit());
        this.mappedFile = mappedFile;
        this.clear();
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull String filename, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(file, chunkSize, OS.pageSize());
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException, IllegalStateException {
        MappedFile rw = MappedFile.of(file, chunkSize, overlapSize);
        return MappedBytes.mappedBytes(rw);
    }

    @NotNull
    public static MappedBytes mappedBytes(MappedFile rw) {
        return CHECKING ? new CheckingMappedBytes(rw) : new MappedBytes(rw);
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.mappedFile.setNewChunkListener(listener);
    }

    public MappedFile mappedFile() {
        return this.mappedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedBytes withSizes(long chunkSize, long overlapSize) {
        MappedFile mappedFile2 = this.mappedFile.withSizes(chunkSize, overlapSize);
        if (mappedFile2 == this.mappedFile) {
            return this;
        }
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(mappedFile2);
            return mappedBytes;
        }
        finally {
            this.release();
        }
    }

    @Override
    public BytesStore<Bytes<Void>, Void> copy() {
        return NativeBytes.copyOf(this);
    }

    @Override
    public long capacity() {
        return this.mappedFile == null ? 0L : this.mappedFile.capacity();
    }

    @Override
    public long realCapacity() {
        return this.mappedFile.actualSize();
    }

    @Override
    public long refCount() {
        return Math.max(super.refCount(), this.mappedFile.refCount());
    }

    @Override
    protected void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException, IORuntimeException {
        if (!this.bytesStore.inside(offset)) {
            BytesStore oldBS = this.bytesStore;
            try {
                this.bytesStore = this.mappedFile.acquireByteStore(offset);
                oldBS.release();
            }
            catch (IOException | IllegalStateException e) {
                throw new IORuntimeException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new BufferUnderflowException();
            }
        }
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IORuntimeException {
        if (offset < 0L || offset > this.capacity() - adding) {
            throw new IllegalArgumentException("Offset out of bound " + offset);
        }
        if (!this.bytesStore.inside(offset)) {
            BytesStore oldBS = this.bytesStore;
            try {
                this.bytesStore = this.mappedFile.acquireByteStore(offset);
                oldBS.release();
            }
            catch (IOException | IllegalStateException e) {
                throw new IORuntimeException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new BufferOverflowException();
            }
        }
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    protected void performRelease() {
        super.performRelease();
        this.mappedFile.close();
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NotNull BytesStore bytes, long offset, long length) throws IORuntimeException, BufferUnderflowException, BufferOverflowException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.bytesStore() instanceof NativeBytesStore && length >= 16L) {
            this.rawCopy(bytes, offset, length);
        } else {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    public void rawCopy(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
        if (len > 0L) {
            OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
            this.writePosition += len;
        }
    }
}

