/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.StoreRef;
import net.openhft.chronicle.core.util.WeakReferenceCleaner;
import net.openhft.chronicle.core.values.BooleanValue;
import org.jetbrains.annotations.NotNull;

public class TextBooleanReference
implements BooleanValue,
Byteable {
    private BytesStore bytes;
    private long offset;
    private static final int FALSE = 1936482662;
    private static final int TRUE = 1970435104;
    private final StoreRef ref = new StoreRef();

    public TextBooleanReference() {
        WeakReferenceCleaner.newCleaner((Object)this, this.ref::clean);
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        this.acceptNewBytesStore(bytes);
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return 5L;
    }

    @NotNull
    public String toString() {
        return "value: " + this.getValue();
    }

    public boolean getValue() {
        return this.bytes.readVolatileInt(this.offset) == 1970435104;
    }

    public void setValue(boolean value) {
        TextBooleanReference.write(value, this.bytes, this.offset);
    }

    public static void write(boolean value, BytesStore bytes, long offset) {
        bytes.writeVolatileInt(offset, value ? 1970435104 : 1936482662);
        bytes.writeByte(offset + 4L, (byte)101);
    }

    private void acceptNewBytesStore(BytesStore bytes) {
        if (this.bytes != null) {
            this.bytes.release();
        }
        this.ref.b = this.bytes = bytes.bytesStore();
        this.bytes.reserve();
    }
}

