/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StreamingDataInput;

public class StreamingInputStream
extends InputStream {
    StreamingDataInput in;

    public static StreamingInputStream uninitialized() {
        return new StreamingInputStream();
    }

    private StreamingInputStream() {
    }

    public StreamingInputStream(StreamingDataInput in) {
        this.in = in;
    }

    public void init(StreamingDataInput in) {
        this.in = in;
    }

    @Override
    public long skip(long n) throws IOException {
        long len = Math.min(this.in.readRemaining(), n);
        this.in.readSkip(len);
        return len;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.in.readRemaining());
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len);
        }
        catch (IORuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.in.readRemaining() > 0L ? this.in.readUnsignedByte() : -1;
        }
        catch (IORuntimeException e) {
            throw new IOException(e);
        }
    }
}

