/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesPrepender;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ExpectedBytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.bytes.UncheckedNativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public interface Bytes<Underlying>
extends BytesStore<Bytes<Underlying>, Underlying>,
StreamingDataInput<Bytes<Underlying>>,
StreamingDataOutput<Bytes<Underlying>>,
ByteStringParser<Bytes<Underlying>>,
ByteStringAppender<Bytes<Underlying>>,
BytesPrepender<Bytes<Underlying>> {
    public static final long MAX_CAPACITY = Long.MAX_VALUE;

    public static Bytes<ByteBuffer> elasticByteBuffer() {
        NativeBytesStore<ByteBuffer> bs = NativeBytesStore.elasticByteBuffer();
        try {
            Bytes bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<ByteBuffer> elasticByteBuffer(int initialCapacity) {
        NativeBytesStore<ByteBuffer> bs = NativeBytesStore.elasticByteBuffer(initialCapacity);
        try {
            Bytes bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<ByteBuffer> wrapForRead(ByteBuffer byteBuffer) {
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bytes = bs.bytesForRead();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<ByteBuffer> wrapForWrite(ByteBuffer byteBuffer) {
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    @NotNull
    public static Bytes<byte[]> expect(@NotNull String text) {
        return Bytes.expect(Bytes.wrapForRead(text.getBytes(StandardCharsets.ISO_8859_1)));
    }

    @NotNull
    public static <B extends BytesStore<B, Underlying>, Underlying> Bytes<Underlying> expect(BytesStore<B, Underlying> bytesStore) {
        return new VanillaBytes(new ExpectedBytesStore<B, Underlying>(bytesStore));
    }

    public static Bytes<byte[]> wrapForRead(byte[] byteArray) {
        HeapBytesStore<byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForRead();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<byte[]> wrapForWrite(byte[] byteArray) {
        HeapBytesStore<byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<byte[]> from(@NotNull CharSequence text) throws IllegalArgumentException, IllegalStateException {
        if (text instanceof BytesStore) {
            return ((BytesStore)text).copy().bytesForRead();
        }
        return Bytes.wrapForRead(text.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    @Deprecated
    public static Bytes<byte[]> wrapForRead(@NotNull CharSequence text) throws IllegalArgumentException, IllegalStateException {
        return Bytes.from(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VanillaBytes<Void> allocateDirect(long capacity) throws IllegalArgumentException {
        NativeBytesStore<Void> bs = NativeBytesStore.nativeStoreWithFixedCapacity(capacity);
        try {
            Bytes bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static NativeBytes<Void> allocateElasticDirect() {
        return NativeBytes.nativeBytes();
    }

    public static NativeBytes<Void> allocateElasticDirect(long initialCapacity) throws IllegalArgumentException {
        return NativeBytes.nativeBytes(initialCapacity);
    }

    public static String toString(@NotNull Bytes<?> buffer) throws BufferUnderflowException {
        if (buffer.readRemaining() == 0L) {
            return "";
        }
        return (String)buffer.parseWithLength(buffer.readRemaining(), b -> {
            StringBuilder builder = new StringBuilder();
            try {
                while (buffer.readRemaining() > 0L) {
                    builder.append((char)buffer.readByte());
                }
            }
            catch (IORuntimeException e) {
                builder.append(' ').append(e);
            }
            return builder.toString();
        });
    }

    public static String toString(@NotNull Bytes<?> buffer, long maxLen) throws BufferUnderflowException {
        if (buffer.readRemaining() == 0L) {
            return "";
        }
        long length = maxLen < buffer.readRemaining() ? maxLen : buffer.readRemaining();
        return (String)buffer.parseWithLength(length, b -> {
            StringBuilder builder = new StringBuilder();
            try {
                while (buffer.readRemaining() > 0L) {
                    builder.append((char)buffer.readByte());
                }
            }
            catch (IORuntimeException e) {
                builder.append(' ').append(e);
            }
            return builder.toString();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(@NotNull Bytes buffer, long position, long len) throws BufferUnderflowException, IORuntimeException {
        long pos = buffer.readPosition();
        long limit = buffer.readLimit();
        buffer.readPosition(position);
        buffer.readLimit(position + len);
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.readLimit(limit);
            buffer.readPosition(pos);
        }
    }

    public static BytesStore empty() {
        return NoBytesStore.noBytesStore();
    }

    public static Bytes allocateDirect(@NotNull byte[] bytes) throws IllegalArgumentException {
        VanillaBytes<Void> result = Bytes.allocateDirect(bytes.length);
        try {
            result.write(bytes);
        }
        catch (BufferOverflowException | IORuntimeException e) {
            throw new AssertionError((Object)e);
        }
        return result;
    }

    default public Bytes<Underlying> unchecked(boolean unchecked) throws IllegalStateException {
        return unchecked ? (this.start() == 0L && this.bytesStore() instanceof NativeBytesStore ? new UncheckedNativeBytes(this) : new UncheckedBytes(this)) : this;
    }

    @Override
    default public long safeLimit() {
        return this.bytesStore().safeLimit();
    }

    @Override
    default public boolean isClear() {
        return this.start() == this.readPosition() && this.writeLimit() == this.capacity();
    }

    @Override
    default public long realCapacity() {
        return BytesStore.super.realCapacity();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy();

    @NotNull
    default public String toHexString() throws IORuntimeException {
        return BytesInternal.toHexString(this);
    }

    @NotNull
    default public String toHexString(long maxLength) throws IORuntimeException {
        if (this.readRemaining() < maxLength) {
            return this.toHexString();
        }
        return BytesInternal.toHexString(this, this.readPosition(), maxLength) + ".... truncated";
    }

    @NotNull
    default public String toHexString(long offset, long maxLength) throws IORuntimeException {
        long maxLength2 = Math.min(maxLength, this.readLimit() - offset);
        String ret = BytesInternal.toHexString(this, offset, maxLength2);
        return maxLength2 < maxLength ? ret + "... truncated" : ret;
    }

    public boolean isElastic();

    default public void ensureCapacity(long size) throws IllegalArgumentException, IORuntimeException {
        if (size > this.capacity()) {
            throw new IllegalArgumentException(this.isElastic() ? "todo" : "not elastic");
        }
    }

    @Override
    default public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        return this.isClear() ? BytesStore.super.bytesForRead() : new SubBytes((BytesStore)this, this.readPosition(), this.readLimit() + this.start());
    }

    @Override
    public BytesStore bytesStore();

    default public boolean isEqual(String s) {
        return StringUtils.isEqual((CharSequence)this, (CharSequence)s);
    }
}

