/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StreamingDataOutput;

class StreamingOutputStream
extends OutputStream {
    private final StreamingDataOutput sdo;

    public StreamingOutputStream(StreamingDataOutput sdo) {
        this.sdo = sdo;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.sdo.write(b, off, len);
        }
        catch (IllegalArgumentException | BufferOverflowException | IORuntimeException e) {
            throw new IOException((Throwable)e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.sdo.writeUnsignedByte(b);
        }
        catch (IllegalArgumentException | BufferOverflowException | IORuntimeException e) {
            throw new IOException((Throwable)e);
        }
    }
}

