/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class NativeBytesStore<Underlying>
implements BytesStore<NativeBytesStore<Underlying>, Underlying> {
    private static final long MEMORY_MAPPED_SIZE = 131072L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeBytesStore.class);
    @Nullable
    private final Cleaner cleaner;
    private final boolean elastic;
    @Nullable
    private final Underlying underlyingObject;
    @Nullable
    private final Throwable createdHere = Jvm.isDebug() ? new Throwable("Created here") : null;
    @Nullable
    protected Memory memory = OS.memory();
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    protected long address;
    long maximumLimit;
    private Error releasedHere;

    private NativeBytesStore(@NotNull ByteBuffer bb, boolean elastic) {
        this.elastic = elastic;
        this.underlyingObject = bb;
        this.setAddress(((DirectBuffer)((Object)bb)).address());
        this.maximumLimit = bb.capacity();
        this.cleaner = ((DirectBuffer)((Object)bb)).cleaner();
    }

    public NativeBytesStore(long address, long maximumLimit) {
        this(address, maximumLimit, null, false);
    }

    public NativeBytesStore(long address, long maximumLimit, @Nullable Runnable deallocator, boolean elastic) {
        this.setAddress(address);
        this.maximumLimit = maximumLimit;
        this.cleaner = deallocator == null ? null : Cleaner.create((Object)this, (Runnable)deallocator);
        this.underlyingObject = null;
        this.elastic = elastic;
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new NativeBytesStore<ByteBuffer>(bb, false);
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStore(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, true);
    }

    @NotNull
    private static NativeBytesStore<Void> of(long capacity, boolean zeroOut, boolean elastic) throws IllegalArgumentException {
        Memory memory = OS.memory();
        long address = memory.allocate(capacity);
        if (zeroOut || capacity < 131072L) {
            memory.setMemory(address, capacity, (byte)0);
            memory.storeFence();
        }
        Deallocator deallocator = new Deallocator(address, capacity);
        return new NativeBytesStore<Void>(address, capacity, deallocator, elastic);
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStoreWithFixedCapacity(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, false);
    }

    @NotNull
    public static NativeBytesStore<Void> lazyNativeBytesStoreWithFixedCapacity(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, false, false);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer(OS.pageSize());
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer(int size) {
        return new NativeBytesStore<ByteBuffer>(ByteBuffer.allocateDirect(size), true);
    }

    @Override
    @NotNull
    public BytesStore<NativeBytesStore<Underlying>, Underlying> copy() throws IllegalStateException {
        if (this.underlyingObject == null) {
            NativeBytesStore<Void> copy = NativeBytesStore.of(this.realCapacity(), false, true);
            OS.memory().copyMemory(this.address, copy.address, this.capacity());
            return copy;
        }
        if (this.underlyingObject instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.capacity()));
            bb.put((ByteBuffer)this.underlyingObject);
            bb.clear();
            return NativeBytesStore.wrap(bb);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public VanillaBytes<Underlying> bytesForWrite() throws IllegalStateException {
        return this.elastic ? new NativeBytes(this) : new VanillaBytes(this);
    }

    @Override
    @ForceInline
    public long realCapacity() {
        return this.maximumLimit;
    }

    @Override
    @ForceInline
    public long capacity() {
        return this.maximumLimit;
    }

    @Override
    @ForceInline
    @Nullable
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> zeroOut(long start, long end) throws IllegalArgumentException {
        if (start < this.writePosition() || end > this.writeLimit()) {
            throw new IllegalArgumentException("position: " + this.writePosition() + ", start: " + start + ", end: " + end + ", limit: " + this.writeLimit());
        }
        if (start >= end) {
            return this;
        }
        this.memory.setMemory(this.address + this.translate(start), end - start, (byte)0);
        return this;
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        return this.memory.compareAndSwapInt(this.address + this.translate(offset), expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        return this.memory.compareAndSwapLong(this.address + this.translate(offset), expected, value);
    }

    long translate(long offset) {
        long offset2 = offset - this.start();
        return offset2;
    }

    @Override
    public long start() {
        return 0L;
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
        if (Jvm.isDebug() && this.refCount.get() == 0L) {
            this.releasedHere = new Error("Released here");
        }
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    @ForceInline
    public byte readByte(long offset) {
        if (Jvm.isDebug()) {
            this.checkReleased();
        }
        return this.memory.readByte(this.address + this.translate(offset));
    }

    public void checkReleased() {
        if (this.releasedHere != null) {
            throw new InternalError("Accessing a released resource", this.releasedHere);
        }
    }

    @Override
    @ForceInline
    public short readShort(long offset) {
        return this.memory.readShort(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public int readInt(long offset) {
        return this.memory.readInt(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public long readLong(long offset) {
        return this.memory.readLong(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public float readFloat(long offset) {
        return this.memory.readFloat(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public double readDouble(long offset) {
        return this.memory.readDouble(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public int readVolatileInt(long offset) {
        return this.memory.readVolatileInt(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public long readVolatileLong(long offset) {
        return this.memory.readVolatileLong(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeByte(long offset, byte i8) {
        this.memory.writeByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeShort(long offset, short i16) {
        this.memory.writeShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeInt(long offset, int i32) {
        this.memory.writeInt(this.address + this.translate(offset), i32);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeOrderedInt(long offset, int i) {
        this.memory.writeOrderedInt(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeLong(long offset, long i64) {
        this.memory.writeLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeOrderedLong(long offset, long i) {
        this.memory.writeOrderedLong(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeFloat(long offset, float f) {
        this.memory.writeFloat(this.address + this.translate(offset), f);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeDouble(long offset, double d) {
        this.memory.writeDouble(this.address + this.translate(offset), d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        this.memory.copyMemory(bytes, offset, this.address + this.translate(offsetInRDO), length);
        return this;
    }

    @Override
    @ForceInline
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) {
        if (bytes.isDirect()) {
            this.memory.copyMemory(((DirectBuffer)((Object)bytes)).address(), this.address + this.translate(offsetInRDO), (long)length);
        } else {
            this.memory.copyMemory(bytes.array(), offset, this.address + this.translate(offsetInRDO), length);
        }
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> write(long offsetInRDO, @NotNull RandomDataInput bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException, IORuntimeException {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            this.writeLong(offsetInRDO + i, bytes.readLong(offset + i));
        }
        while (i < length) {
            this.writeByte(offsetInRDO + i, bytes.readByte(offset + i));
            ++i;
        }
        return this;
    }

    @Override
    public long address(long offset) throws UnsupportedOperationException {
        if (offset < this.start() || offset >= this.capacity()) {
            throw new IllegalArgumentException();
        }
        return this.address + this.translate(offset);
    }

    private void performRelease() {
        if (this.refCount.get() > 0L) {
            LOGGER.info("NativeBytesStore discarded without releasing ", this.createdHere);
        }
        this.memory = null;
        if (this.cleaner != null) {
            this.cleaner.clean();
        }
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return BytesInternal.toString(this);
        }
        catch (IllegalStateException | IORuntimeException e) {
            return e.toString();
        }
    }

    @Override
    @ForceInline
    public void nativeRead(long position, long address, long size) {
        OS.memory().copyMemory(this.address(position), address, size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long position, long size) {
        this.memory.copyMemory(address, this.address(position), size);
    }

    void write8bit(long position, char[] chars, int offset, int length) {
        long addr = this.address + this.translate(position);
        Memory memory = this.memory;
        for (int i = 0; i < length; ++i) {
            memory.writeByte(addr + (long)i, (byte)chars[offset + i]);
        }
    }

    void read8bit(long position, char[] chars, int length) {
        long addr = this.address + this.translate(position);
        Memory memory = OS.memory();
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(memory.readByte(addr + (long)i) & 0xFF);
        }
    }

    @Override
    public long readIncompleteLong(long offset) {
        int remaining = (int)Math.min(8L, this.readRemaining() - offset);
        long l = 0L;
        for (int i = 0; i < remaining; ++i) {
            byte b = this.memory.readByte(this.address + offset + (long)i);
            l |= (long)(b & 0xFF) << i * 8;
        }
        return l;
    }

    public boolean equals(Object obj) {
        try {
            return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
        }
        catch (IORuntimeException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setAddress(long address) {
        if ((address & 0xFFFFFFFFFFFFC000L) == 0L) {
            throw new AssertionError((Object)("Invalid address " + Long.toHexString(address)));
        }
        this.address = address;
    }

    public long appendUTF(long pos, char[] chars, int offset, int length) {
        int i;
        block2: {
            long address = this.address + this.translate(0L);
            Memory memory = this.memory;
            for (i = 0; i < length; ++i) {
                char c = chars[offset + i];
                if (c <= '\u007f') {
                    memory.writeByte(address + pos++, (byte)c);
                    continue;
                }
                break block2;
            }
            return pos;
        }
        return this.appendUTF0(pos, chars, offset, length, i);
    }

    private long appendUTF0(long pos, char[] chars, int offset, int length, int i) {
        while (i < length) {
            char c = chars[offset + i];
            if (c <= '\u007f') {
                this.writeByte(pos++, (byte)c);
            } else if (c <= '\u07ff') {
                this.writeByte(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            } else {
                this.writeByte(pos++, (byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
        return pos;
    }

    static class Deallocator
    implements Runnable {
        private volatile long address;
        private volatile long size;

        Deallocator(long address, long size) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            this.address = 0L;
            OS.memory().freeMemory(this.address, this.size);
        }
    }
}

