/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;

public interface RandomDataOutput<R extends RandomDataOutput<R>>
extends RandomCommon {
    default public R writeByte(long offset, int i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        return this.writeByte(offset, Maths.toInt8((long)i));
    }

    default public R writeUnsignedByte(long offset, int i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        return this.writeByte(offset, (byte)Maths.toUInt8((long)i));
    }

    default public R writeBoolean(long offset, boolean flag) throws BufferOverflowException, IORuntimeException {
        try {
            return this.writeByte(offset, flag ? 89 : 0);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public R writeUnsignedShort(long offset, int i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        return this.writeShort(offset, (short)Maths.toUInt16((long)i));
    }

    default public R writeUnsignedInt(long offset, long i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        return this.writeInt(offset, (int)Maths.toUInt32((long)i));
    }

    public R writeByte(long var1, byte var3) throws BufferOverflowException, IORuntimeException;

    public R writeShort(long var1, short var3) throws BufferOverflowException, IORuntimeException;

    public R writeInt(long var1, int var3) throws BufferOverflowException, IORuntimeException;

    public R writeOrderedInt(long var1, int var3) throws BufferOverflowException, IORuntimeException;

    default public R writeOrderedFloat(long offset, float f) throws BufferOverflowException, IORuntimeException {
        return this.writeOrderedInt(offset, Float.floatToRawIntBits(f));
    }

    public R writeLong(long var1, long var3) throws BufferOverflowException, IORuntimeException;

    public R writeOrderedLong(long var1, long var3) throws BufferOverflowException, IORuntimeException;

    default public R writeOrderedDouble(long offset, double d) throws BufferOverflowException, IORuntimeException {
        return this.writeOrderedLong(offset, Double.doubleToRawLongBits(d));
    }

    public R writeFloat(long var1, float var3) throws BufferOverflowException, IORuntimeException;

    public R writeDouble(long var1, double var3) throws BufferOverflowException, IORuntimeException;

    default public R write(long offsetInRDO, @NotNull byte[] bytes) throws BufferOverflowException, IORuntimeException {
        try {
            return this.write(offsetInRDO, bytes, 0, bytes.length);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public R write(long var1, byte[] var3, int var4, int var5) throws BufferOverflowException, IllegalArgumentException, IORuntimeException;

    public void write(long var1, ByteBuffer var3, int var4, int var5) throws BufferOverflowException, IllegalArgumentException, IORuntimeException;

    default public R write(long offsetInRDO, @NotNull Bytes bytes) throws BufferOverflowException, IORuntimeException {
        try {
            return this.write(offsetInRDO, bytes, bytes.readPosition(), bytes.readRemaining());
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public R write(long var1, RandomDataInput var3, long var4, long var6) throws BufferOverflowException, IllegalArgumentException, IORuntimeException, BufferUnderflowException;

    public R zeroOut(long var1, long var3) throws IllegalArgumentException, IORuntimeException;

    @NotNull
    default public R append(long offset, long value, int digits) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        BytesInternal.append(this, offset, value, digits);
        return (R)this;
    }

    public void nativeWrite(long var1, long var3, long var5);
}

