/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.util.StringUtils;

public enum BytesUtil {


    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence) {
            return StringUtils.isEqual((CharSequence)((CharSequence)o1), (CharSequence)((CharSequence)o2));
        }
        return o1 != null && o1.equals(o2);
    }

    public static int asInt(@NotNull String str) {
        ByteBuffer bb = ByteBuffer.wrap(str.getBytes(StandardCharsets.ISO_8859_1)).order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    public static int stopBitLength(long n) {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        return BytesInternal.stopBitlength0(n);
    }
}

