/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ReferenceCounted;

public interface BytesStore<B extends BytesStore<B, Underlying>, Underlying>
extends RandomDataInput,
RandomDataOutput<B>,
ReferenceCounted,
CharSequence {
    public static BytesStore wrap(byte[] bytes) {
        return HeapBytesStore.wrap(ByteBuffer.wrap(bytes));
    }

    public static BytesStore wrap(ByteBuffer bb) {
        return bb.isDirect() ? NativeBytesStore.wrap(bb) : HeapBytesStore.wrap(bb);
    }

    public static PointerBytesStore nativePointer() {
        return new PointerBytesStore();
    }

    public BytesStore<B, Underlying> copy();

    @Override
    default public Bytes<Underlying> bytesForRead() {
        return (Bytes)this.bytesForWrite().readLimit(this.writeLimit());
    }

    @Override
    default public Bytes<Underlying> bytesForWrite() {
        return new VanillaBytes(this, this.writePosition(), this.writeLimit());
    }

    default public boolean isClear() {
        return true;
    }

    default public long realCapacity() {
        return this.capacity();
    }

    @Override
    public long capacity();

    public Underlying underlyingObject();

    default public boolean inside(long offset) {
        return this.start() <= offset && offset < this.safeLimit();
    }

    default public long safeLimit() {
        return this.capacity();
    }

    default public void copyTo(BytesStore store) {
        long copy = Math.min(this.capacity(), store.capacity());
        int i = 0;
        while ((long)i < copy - 7L) {
            store.writeLong(i, this.readLong(i));
            ++i;
        }
        while ((long)i < copy) {
            store.writeByte((long)i, this.readByte(i));
            ++i;
        }
    }

    @Override
    default public B zeroOut(long start, long end) {
        long i;
        if (end <= start) {
            return (B)this;
        }
        if (start < this.start() || end > this.capacity()) {
            throw new IllegalArgumentException();
        }
        for (i = start; i < end - 7L; ++i) {
            this.writeLong(i, 0L);
        }
        while (i < end) {
            this.writeByte(i, 0);
            ++i;
        }
        return (B)this;
    }

    public boolean compareAndSwapInt(long var1, int var3, int var4);

    public boolean compareAndSwapLong(long var1, long var3, long var5);

    default public int addAndGetInt(long offset, int adding) {
        return BytesUtil.getAndAddInt(this, offset, adding) + adding;
    }

    default public int getAndAddInt(long offset, int adding) {
        return BytesUtil.getAndAddInt(this, offset, adding);
    }

    default public long addAndGetLong(long offset, long adding) {
        return BytesUtil.getAndAddLong(this, offset, adding) + adding;
    }

    @Override
    default public int length() {
        return (int)Math.min(Integer.MAX_VALUE, this.readRemaining());
    }

    @Override
    default public char charAt(int index) {
        return (char)this.readUnsignedByte(index);
    }

    @Override
    default public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException("todo");
    }

    default public String toDebugString() {
        return BytesUtil.toDebugString(this, Integer.MAX_VALUE);
    }

    default public BytesStore bytesStore() {
        return this;
    }

    default public boolean equalBytes(BytesStore b, long remaining) {
        long i;
        BytesStore b2 = b.bytesStore();
        for (i = 0L; i < remaining - 7L; ++i) {
            long l2;
            long l0 = this.readLong(this.readPosition() + i);
            if (l0 == (l2 = b2.readLong(b.readPosition() + i))) continue;
            return false;
        }
        while (i < remaining) {
            byte b1;
            byte b0 = this.readByte(this.readPosition() + i);
            if (b0 != (b1 = b2.readByte(b.readPosition() + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    default public int byteCheckSum() {
        int b = 0;
        for (long i = this.readPosition(); i < this.readLimit(); ++i) {
            b = (byte)(b + this.readByte(i));
        }
        return b & 0xFF;
    }
}

