/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.Nullable;

public interface StreamingDataInput<S extends StreamingDataInput<S>>
extends StreamingCommon<S> {
    public S readPosition(long var1);

    public S readLimit(long var1);

    default public void readWithLength(long length, Consumer<S> bytesConsumer) {
        this.parseWithLength(length, s -> {
            bytesConsumer.accept(s);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R parseWithLength(long length, Function<S, R> bytesConsumer) {
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            R r = bytesConsumer.apply(this);
            return r;
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    default public InputStream inputStream() {
        throw new UnsupportedOperationException();
    }

    default public long readStopBit() {
        return BytesUtil.readStopBit(this);
    }

    default public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte();

    default public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public short readShort();

    default public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readInt();

    default public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong();

    public float readFloat();

    public double readDouble();

    @Nullable
    default public String readUTF\u0394() {
        return BytesUtil.readUTF\u0394(this);
    }

    default public <ACS extends Appendable & CharSequence> boolean readUTF\u0394(ACS sb) throws UTFDataFormatRuntimeException {
        BytesUtil.setLength(sb, 0);
        long len0 = BytesUtil.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        BytesUtil.parseUTF(this, sb, len);
        return true;
    }

    default public void read(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.readByte();
        }
    }

    default public void read(ByteBuffer buffer) {
        for (int i = (int)Math.min(this.readRemaining(), (long)buffer.remaining()); i > 0; --i) {
            buffer.put(this.readByte());
        }
    }

    public int readVolatileInt();

    public long readVolatileLong();

    public int peekUnsignedByte();

    public void nativeRead(long var1, long var3);
}

