/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;

public class ExpectedBytesStore<B extends BytesStore<B, Underlying>, Underlying>
implements BytesStore<B, Underlying> {
    private static final int NOT_READY = Integer.MIN_VALUE;
    private final BytesStore<B, Underlying> underlyingBytesStore;

    ExpectedBytesStore(BytesStore<B, Underlying> underlyingBytesStore) {
        this.underlyingBytesStore = underlyingBytesStore;
    }

    @Override
    public BytesStore<B, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public long capacity() {
        return this.underlyingBytesStore.capacity();
    }

    @Override
    public Underlying underlyingObject() {
        return this.underlyingBytesStore.underlyingObject();
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readInt(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double readDouble(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public B writeByte(long offset, byte i8) {
        byte i8a = this.underlyingBytesStore.readByte(offset);
        if (i8a != i8) {
            Bytes<Underlying> bytes = this.underlyingBytesStore.bytesForRead();
            bytes.readPosition(offset);
            throw new AssertionError((Object)(bytes.toDebugString() + "\nExpected: " + i8a + "\nActual: " + i8));
        }
        return (B)this;
    }

    @Override
    public long address() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public B writeShort(long offset, short i) {
        short ia = this.underlyingBytesStore.readShort(offset);
        if (ia != i) {
            throw new AssertionError((Object)("Expected: " + ia + "\nActual: " + i));
        }
        return (B)this;
    }

    @Override
    public B writeInt(long offset, int i) {
        int ia = this.underlyingBytesStore.readInt(offset);
        if (ia != i) {
            throw new AssertionError((Object)("Expected: " + ia + "\nActual: " + i));
        }
        return (B)this;
    }

    public void reserve() throws IllegalStateException {
    }

    @Override
    public B writeOrderedInt(long offset, int i) {
        int ia = this.underlyingBytesStore.readInt(offset);
        if (ia != i && (i & Integer.MIN_VALUE) == 0) {
            throw new AssertionError((Object)("Expected: " + ia + " <" + Integer.toHexString(ia) + ">\nActual: " + i + " <" + Integer.toHexString(i) + ">"));
        }
        return (B)this;
    }

    public void release() throws IllegalStateException {
    }

    @Override
    public B writeLong(long offset, long i) {
        long ia = this.underlyingBytesStore.readLong(offset);
        if (ia != i) {
            throw new AssertionError((Object)("Expected: " + ia + "\nActual: " + i));
        }
        return (B)this;
    }

    public long refCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public B writeOrderedLong(long offset, long i) {
        long ia = this.underlyingBytesStore.readLong(offset);
        if (ia != i) {
            throw new AssertionError((Object)("Expected: " + ia + "\nActual: " + i));
        }
        return (B)this;
    }

    @Override
    public B writeFloat(long offset, float d) {
        float ia = this.underlyingBytesStore.readFloat(offset);
        if (ia != d) {
            throw new AssertionError((Object)("Expected: " + ia + "\nActual: " + d));
        }
        return (B)this;
    }

    @Override
    public B writeDouble(long offset, double d) {
        double ia = this.underlyingBytesStore.readDouble(offset);
        if (ia != d) {
            throw new AssertionError((Object)("Expected: " + ia + "\nActual: " + d));
        }
        return (B)this;
    }

    @Override
    public B write(long offsetInRDO, byte[] bytes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.writeByte(offsetInRDO + (long)i, bytes[offset + i]);
        }
        return (B)this;
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public B write(long offsetInRDO, RandomDataInput bytes, long offset, long length) {
        throw new UnsupportedOperationException();
    }
}

