/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.core.Maths;

public interface StreamingDataOutput<S extends StreamingDataOutput<S>>
extends StreamingCommon<S> {
    default public OutputStream outputStream() {
        throw new UnsupportedOperationException();
    }

    default public S writeStopBit(long x) {
        BytesUtil.writeStopBit(this, x);
        return (S)this;
    }

    public S writePosition(long var1);

    public S writeLimit(long var1);

    default public S writeUTF\u0394(CharSequence cs) throws BufferOverflowException {
        BytesUtil.writeUTF(this, cs);
        return (S)this;
    }

    public S writeByte(byte var1);

    default public S writeUnsignedByte(int i) {
        return this.writeByte((byte)Maths.toUInt8((long)i));
    }

    public S writeShort(short var1);

    default public S writeUnsignedShort(int u16) {
        return this.writeShort((short)Maths.toUInt16((long)u16));
    }

    public S writeInt(int var1);

    default public S writeUnsignedInt(long i) {
        return this.writeInt((int)Maths.toUInt32((long)i));
    }

    public S writeLong(long var1);

    public S writeFloat(float var1);

    public S writeDouble(double var1);

    default public S write(BytesStore bytes) {
        return this.write(bytes, bytes.readPosition(), bytes.readRemaining());
    }

    public S write(BytesStore var1, long var2, long var4);

    default public S write(byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    public S write(byte[] var1, int var2, int var3);

    public S write(ByteBuffer var1);

    default public S writeBoolean(boolean flag) {
        return this.writeByte(flag ? (byte)89 : 0);
    }

    public S writeOrderedInt(int var1);

    public S writeOrderedLong(long var1);

    public void nativeWrite(long var1, long var3);
}

