/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.WriteAccess;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.pool.StringInterner;
import org.jetbrains.annotations.NotNull;

public final class BytesUtil
extends Enum<BytesUtil> {
    private static final byte[] MIN_VALUE_TEXT;
    private static final StringBuilderPool SBP;
    private static final StringInterner SI;
    private static final byte[] Infinity;
    private static final byte[] NaN;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final ThreadLocal<byte[]> NUMBER_BUFFER;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    static final char[] HEXI_DECIMAL;
    private static final /* synthetic */ BytesUtil[] $VALUES;

    public static BytesUtil[] values() {
        return (BytesUtil[])$VALUES.clone();
    }

    public static BytesUtil valueOf(String name) {
        return Enum.valueOf(BytesUtil.class, name);
    }

    public static void parseUTF(StreamingDataInput bytes, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        try {
            int count;
            assert (bytes.remaining() >= (long)utflen);
            for (count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                if (c >= 128) {
                    bytes.position(bytes.position() - 1L);
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (utflen > count) {
                BytesUtil.parseUTF2(bytes, appendable, utflen, count);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static void parseUTF2(StreamingDataInput bytes, Appendable appendable, int utflen, int count) throws IOException {
        block5: while (count < utflen) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + count + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (count - 1) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw new UTFDataFormatRuntimeException("malformed input around byte " + count);
        }
    }

    public static void writeUTF(StreamingDataOutput bytes, CharSequence str) {
        if (str == null) {
            bytes.writeStopBit(-1L);
        } else {
            bytes.writeStopBit(BytesUtil.findUTFLength(str));
            BytesUtil.appendUTF(bytes, str, 0, str.length());
        }
    }

    public static long findUTFLength(@NotNull CharSequence str) {
        long utflen = 0L;
        int strlen = str.length();
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c <= '\u07ff') {
                utflen += 2L;
                continue;
            }
            utflen += 3L;
        }
        return utflen;
    }

    public static void appendUTF(StreamingDataOutput bytes, @NotNull CharSequence str, int offset, int length) {
        char c;
        int i;
        if (bytes instanceof NativeBytes && str instanceof NativeBytes) {
            ((NativeBytes)bytes).write((NativeBytes)str, (long)offset, (long)length);
            return;
        }
        for (i = 0; i < length && (c = str.charAt(offset + i)) <= '\u007f'; ++i) {
            bytes.writeByte((byte)c);
        }
        while (i < length) {
            c = str.charAt(offset + i);
            BytesUtil.appendUTF(bytes, c);
            ++i;
        }
    }

    public static <T> void appendUTF(WriteAccess<T> access, T handle, long offset, @NotNull CharSequence str, int strOff, int length) {
        char c;
        int i;
        for (i = 0; i < length && (c = str.charAt(strOff + i)) <= '\u007f'; ++i) {
            access.writeByte(handle, offset, (byte)c);
            ++offset;
        }
        while (i < length) {
            c = str.charAt(strOff + i);
            offset = BytesUtil.appendUTF(access, handle, offset, (int)c);
            ++i;
        }
    }

    public static void appendUTF(StreamingDataOutput bytes, int c) {
        if (c <= 127) {
            bytes.writeByte((byte)c);
        } else if (c <= 2047) {
            bytes.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            bytes.writeByte((byte)(0xE0 | c >> 12 & 0xF));
            bytes.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        } else {
            bytes.writeByte((byte)(0xF0 | c >> 18 & 7));
            bytes.writeByte((byte)(0x80 | c >> 12 & 0x3F));
            bytes.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        }
    }

    public static <T> long appendUTF(WriteAccess<T> access, T handle, long offset, int c) {
        if (c <= 127) {
            access.writeByte(handle, offset, (byte)c);
            return offset + 1L;
        }
        if (c <= 2047) {
            access.writeByte(handle, offset, (byte)(0xC0 | c >> 6 & 0x1F));
            access.writeByte(handle, offset + 1L, (byte)(0x80 | c & 0x3F));
            return offset + 2L;
        }
        if (c <= 65535) {
            access.writeByte(handle, offset, (byte)(0xE0 | c >> 12 & 0xF));
            access.writeByte(handle, offset + 1L, (byte)(0x80 | c >> 6 & 0x3F));
            access.writeByte(handle, offset + 2L, (byte)(0x80 | c & 0x3F));
            return offset + 3L;
        }
        access.writeByte(handle, offset, (byte)(0xF0 | c >> 18 & 7));
        access.writeByte(handle, offset + 1L, (byte)(0x80 | c >> 12 & 0x3F));
        access.writeByte(handle, offset + 2L, (byte)(0x80 | c >> 6 & 0x3F));
        access.writeByte(handle, offset + 3L, (byte)(0x80 | c & 0x3F));
        return offset + 4L;
    }

    public static void writeStopBit(StreamingDataOutput out, long n) {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.writeByte((byte)(n & 0x7FL));
            return;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.writeByte((byte)(n & 0x7FL | 0x80L));
            out.writeByte((byte)(n >> 7));
            return;
        }
        BytesUtil.writeStopBit0(out, n);
    }

    static void writeStopBit0(StreamingDataOutput out, long n) {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.writeByte((byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.writeByte((byte)n);
        } else {
            out.writeByte((byte)(0x80L | n));
            out.writeByte((byte)0);
        }
    }

    public static String toDebugString(RandomDataInput bytes, long maxLength) {
        StringBuilder sb = new StringBuilder(200);
        long position = bytes instanceof StreamingCommon ? ((StreamingCommon)((Object)bytes)).position() : 0L;
        sb.append("[pos: ").append(position).append(", lim: ").append(bytes.readLimit()).append(", cap: ").append(bytes.capacity() == 0x10000000000L ? "1TiB" : Long.valueOf(bytes.capacity())).append(" ] ");
        BytesUtil.toString(bytes, sb, position - maxLength, position, position + maxLength);
        return sb.toString();
    }

    public static String toString(RandomDataInput bytes) {
        StringBuilder sb = new StringBuilder(200);
        BytesUtil.toString(bytes, sb);
        return sb.toString();
    }

    public static void toString(RandomDataInput bytes, Appendable sb, long start, long position, long end) {
        try {
            if (start < 0L) {
                start = 0L;
            }
            if (position > start) {
                long last = Math.min(position, bytes.limit());
                for (long i = start; i < last; ++i) {
                    sb.append(bytes.printable(i));
                }
                sb.append('\u2016');
                if (position >= bytes.limit()) {
                    return;
                }
            }
            if (end > bytes.readLimit()) {
                end = bytes.readLimit();
            }
            for (long i = position; i < end; ++i) {
                sb.append(bytes.printable(i));
            }
        }
        catch (IOException e) {
            try {
                sb.append(e.toString());
            }
            catch (IOException e1) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void toString(RandomDataInput bytes, StringBuilder sb) {
        long start;
        for (long i = start = bytes instanceof StreamingCommon ? ((StreamingCommon)((Object)bytes)).position() : 0L; i < bytes.readLimit(); ++i) {
            sb.append((char)bytes.readUnsignedByte(i));
        }
    }

    public static long readStopBit(StreamingDataInput in) {
        long l = in.readByte();
        if (l >= 0L) {
            return l;
        }
        return BytesUtil.readStopBit0(in, l);
    }

    static long readStopBit0(StreamingDataInput in, long l) {
        long b;
        l &= 0x7FL;
        int count = 7;
        while ((b = (long)in.readByte()) < 0L) {
            l |= (b & 0x7FL) << count;
            count += 7;
        }
        if (b != 0L) {
            if (count > 56) {
                throw new IllegalStateException("Cannot read more than 9 stop bits of positive value");
            }
            return l | b << count;
        }
        if (count > 63) {
            throw new IllegalStateException("Cannot read more than 10 stop bits of negative value");
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static <S extends ByteStringAppender> void append(S out, long num) {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.write(MIN_VALUE_TEXT);
                return;
            }
            out.writeByte((byte)45);
            num = -num;
        }
        if (num == 0L) {
            out.writeByte((byte)48);
        } else {
            BytesUtil.appendLong0(out, num);
        }
    }

    public static void append(RandomDataOutput out, long offset, long num, int digits) {
        boolean negative = num < 0L;
        num = Math.abs(num);
        for (int i = digits - 1; i > 0; --i) {
            out.writeByte(offset + (long)i, (byte)(num % 10L + 48L));
            num /= 10L;
        }
        if (negative) {
            if (num != 0L) {
                BytesUtil.numberTooLarge(digits);
            }
            out.writeByte(offset, 45);
        } else {
            if (num > 9L) {
                BytesUtil.numberTooLarge(digits);
            }
            out.writeByte(offset, (byte)(num % 10L + 48L));
        }
    }

    public static void numberTooLarge(int digits) {
        throw new IllegalArgumentException("Number too large for " + digits + "digits");
    }

    private static void appendLong0(StreamingDataOutput out, long num) {
        byte[] numberBuffer = NUMBER_BUFFER.get();
        int endIndex = BytesUtil.appendLong1(numberBuffer, num);
        out.write(numberBuffer, endIndex, numberBuffer.length - endIndex);
    }

    private static int appendLong1(byte[] numberBuffer, long num) {
        numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        numberBuffer[2] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 2;
        }
        numberBuffer[1] = (byte)(num % 10L + 48L);
        return 1;
    }

    public static void append(StreamingDataOutput out, double d) {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            out.writeByte((byte)45);
        }
        if (exp == 0 && mantissa == 0L) {
            out.writeByte((byte)48);
            return;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                out.write(Infinity);
            } else {
                out.write(NaN);
            }
            return;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                BytesUtil.appendLong0(out, intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    out.writeByte((byte)46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        out.writeByte((byte)(48L + num));
                        double parsedValue = BytesUtil.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                }
                return;
            }
            out.writeByte((byte)48);
            out.writeByte((byte)46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    out.writeByte((byte)48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                out.writeByte((byte)c);
                mantissa -= num << precision;
                double parsedValue = BytesUtil.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        BytesUtil.appendLong0(out, val2);
        for (int i = 0; i < digits; ++i) {
            out.writeByte((byte)48);
        }
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    public static String readUTF\u0394(StreamingDataInput in) {
        StringBuilder sb = SBP.acquireStringBuilder();
        return in.readUTF\u0394(sb) ? SI.intern((CharSequence)sb) : null;
    }

    @NotNull
    public static String parseUTF(StreamingDataInput bytes, @NotNull StopCharTester tester) {
        StringBuilder utfReader = SBP.acquireStringBuilder();
        BytesUtil.parseUTF(bytes, (Appendable)utfReader, tester);
        return SI.intern((CharSequence)utfReader);
    }

    public static void parseUTF(StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharTester tester) {
        BytesUtil.setLength(builder, 0);
        try {
            BytesUtil.readUTF0(bytes, builder, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void readUTF0(StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException {
        int c;
        block13: {
            do {
                if ((c = bytes.readUnsignedByte()) >= 128) break block13;
                if (tester.isStopChar(c)) {
                    return;
                }
                appendable.append((char)c);
            } while (bytes.remaining() != 0L);
            return;
        }
        bytes.skip(-1L);
        block6: while (true) {
            c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block6;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    public static void parseUTF(StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharsTester tester) {
        BytesUtil.setLength(builder, 0);
        try {
            BytesUtil.readUTF0(bytes, builder, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void readUTF0(StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharsTester tester) throws IOException {
        int c;
        block13: {
            do {
                if ((c = bytes.readUnsignedByte()) >= 128) break block13;
                if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                    return;
                }
                appendable.append((char)c);
            } while (bytes.remaining() != 0L);
            return;
        }
        bytes.skip(-1L);
        block6: while (true) {
            c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c3);
                    continue block6;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    public static void parse8bit(StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharsTester tester) {
        builder.setLength(0);
        try {
            BytesUtil.read8bit0(bytes, builder, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse8bit(StreamingDataInput bytes, @NotNull Bytes builder, @NotNull StopCharsTester tester) {
        builder.position(0L);
        try {
            BytesUtil.read8bit0(bytes, builder, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void read8bit0(StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharsTester tester) throws IOException {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte(), bytes.peekUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.remaining() != 0L);
    }

    private static void read8bit0(StreamingDataInput bytes, @NotNull Bytes bytes2, @NotNull StopCharsTester tester) throws IOException {
        int ch = bytes.readUnsignedByte();
        do {
            int next;
            if (tester.isStopChar(ch, next = bytes.readUnsignedByte())) {
                bytes.skip(-1L);
                return;
            }
            bytes2.writeUnsignedByte(ch);
            ch = next;
        } while (bytes.remaining() > 1L);
        if (tester.isStopChar(ch, -1)) {
            bytes.skip(-1L);
            return;
        }
        bytes2.writeUnsignedByte(ch);
    }

    public static double parseDouble(StreamingDataInput in) {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        int ch = in.readUnsignedByte();
        switch (ch) {
            case 78: {
                if (BytesUtil.compareRest(in, "aN")) {
                    return Double.NaN;
                }
                in.skip(-1L);
                return Double.NaN;
            }
            case 73: {
                if (BytesUtil.compareRest(in, "nfinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                in.skip(-1L);
                return Double.NaN;
            }
            case 45: {
                if (BytesUtil.compareRest(in, "Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                negative = true;
                ch = in.readUnsignedByte();
            }
        }
        while (true) {
            if (ch >= 48 && ch <= 57) {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
            } else {
                if (ch != 46) break;
                decimalPlaces = 0;
            }
            if (in.remaining() == 0L) break;
            ch = in.readUnsignedByte();
        }
        return BytesUtil.asDouble(value, exp, negative, decimalPlaces);
    }

    static boolean compareRest(StreamingDataInput in, String s) {
        if ((long)s.length() > in.remaining()) {
            return false;
        }
        long position = in.position();
        for (int i = 0; i < s.length(); ++i) {
            if (in.readUnsignedByte() == s.charAt(i)) continue;
            in.position(position);
            return false;
        }
        return true;
    }

    public static long parseLong(StreamingDataInput in) {
        long num = 0L;
        boolean negative = false;
        while (in.remaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        return negative ? -num : num;
    }

    public static long parseLong(RandomDataInput in, long offset) {
        long num = 0L;
        boolean negative = false;
        while (true) {
            int b;
            if ((b = in.readUnsignedByte(offset++)) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        return negative ? -num : num;
    }

    public static boolean skipTo(ByteStringParser parser, StopCharTester tester) {
        while (parser.remaining() > 0L) {
            int ch = parser.readUnsignedByte();
            if (!tester.isStopChar(ch)) continue;
            return true;
        }
        return false;
    }

    public static int getAndAddInt(BytesStore in, long offset, int adding) {
        int value;
        while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value + adding)) {
        }
        return value;
    }

    public static long getAndAddLong(BytesStore in, long offset, long adding) {
        long value;
        while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value + adding)) {
        }
        return value;
    }

    public static long asLong(@NotNull String str) {
        ByteBuffer bb = ByteBuffer.wrap(str.getBytes(StandardCharsets.ISO_8859_1)).order(ByteOrder.nativeOrder());
        return bb.getLong();
    }

    public static int asInt(@NotNull String str) {
        ByteBuffer bb = ByteBuffer.wrap(str.getBytes(StandardCharsets.ISO_8859_1)).order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHexString(@NotNull Bytes bytes, long offset, long len) {
        if (len == 0L) {
            return "";
        }
        int width = 16;
        long position = bytes.position();
        long limit = bytes.limit();
        try {
            bytes.limit(offset + len);
            bytes.position(offset);
            StringBuilder builder = new StringBuilder();
            long start = offset / (long)width * (long)width;
            long end = (offset + len + (long)width - 1L) / (long)width * (long)width;
            for (long i = start; i < end; i += (long)width) {
                int ch;
                int j;
                String str = Long.toHexString(i);
                for (j = str.length(); j < 8; ++j) {
                    builder.append('0');
                }
                builder.append(str);
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < start || i + (long)j >= offset + len) {
                        builder.append("   ");
                        continue;
                    }
                    builder.append(' ');
                    ch = bytes.readUnsignedByte(i + (long)j);
                    builder.append(HEXI_DECIMAL[ch >> 4]);
                    builder.append(HEXI_DECIMAL[ch & 0xF]);
                }
                builder.append(' ');
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < start || i + (long)j >= offset + len) {
                        builder.append(' ');
                        continue;
                    }
                    ch = bytes.readUnsignedByte(i + (long)j);
                    if (ch < 32 || ch > 126) {
                        ch = 183;
                    }
                    builder.append((char)ch);
                }
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            bytes.limit(limit);
            bytes.position(position);
        }
    }

    public static void setCharAt(@NotNull Appendable sb, int index, char ch) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setCharAt(index, ch);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).writeByte((long)index, ch);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void setLength(@NotNull Appendable sb, int newLength) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setLength(newLength);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).position(newLength);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, double value) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, long value) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static String toHex(@NotNull Bytes buffer) {
        return BytesUtil.toHex(buffer, buffer.position(), buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHex(@NotNull Bytes buffer, long offset, long len) {
        if (len == 0L) {
            return "";
        }
        long position = buffer.position();
        long limit = buffer.limit();
        try {
            buffer.limit(offset + len);
            buffer.position(offset);
            StringBuilder builder = new StringBuilder("[");
            while (buffer.remaining() > 0L) {
                long pos = buffer.position();
                byte b = buffer.readByte();
                char c = (char)b;
                builder.append(c + "(" + String.format("%02X ", b).trim() + ")[" + pos + "]");
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(position);
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(ACS sb, String str) {
        try {
            sb.append(str);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        $VALUES = new BytesUtil[0];
        MIN_VALUE_TEXT = "-9223372036854775808".getBytes();
        SBP = new StringBuilderPool();
        SI = new StringInterner(1024);
        Infinity = "Infinity".getBytes();
        NaN = "NaN".getBytes();
        NUMBER_BUFFER = ThreadLocal.withInitial(() -> new byte[20]);
        HEXI_DECIMAL = "0123456789ABCDEF".toCharArray();
    }
}

