/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.EnumInterner;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.util.StringUtils;

public final class BytesUtil
extends Enum<BytesUtil> {
    static final char[] HEXI_DECIMAL;
    private static final byte[] MIN_VALUE_TEXT;
    private static final StringBuilderPool SBP;
    private static final StringInterner SI;
    private static final byte[] Infinity;
    private static final byte[] NaN;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final ThreadLocal<byte[]> NUMBER_BUFFER;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final Constructor<String> STRING_CONSTRUCTOR;
    private static final Field SB_VALUE;
    private static final Field SB_COUNT;
    private static final ThreadLocal<DateCache> dateCacheTL;
    private static final /* synthetic */ BytesUtil[] $VALUES;

    public static BytesUtil[] values() {
        return (BytesUtil[])$VALUES.clone();
    }

    public static BytesUtil valueOf(String name) {
        return Enum.valueOf(BytesUtil.class, name);
    }

    public static boolean contentEqual(@Nullable BytesStore a, @Nullable BytesStore b) {
        long i;
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.start() != b.start() || a.readRemaining() != b.readRemaining()) {
            return false;
        }
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        long length = a.readRemaining();
        for (i = 0L; i < length - 7L; i += 8L) {
            if (a.readLong(aPos + i) == b.readLong(bPos + i)) continue;
            return false;
        }
        for (i = 0L; i < length; ++i) {
            if (a.readByte(aPos + i) == b.readByte(bPos + i)) continue;
            return false;
        }
        return true;
    }

    public static boolean bytesEqual(@NotNull RandomDataInput a, long aOffset, RandomDataInput b, long bOffset, long len) {
        return a.bytesEqual(aOffset, b, bOffset, len);
    }

    public static void parseUTF(@NotNull StreamingDataInput bytes, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        if (bytes instanceof Bytes && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            BytesUtil.parseUTF_SB1((Bytes)bytes, (StringBuilder)appendable, utflen);
        } else {
            BytesUtil.parseUTF1(bytes, appendable, utflen);
        }
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        if (bytes instanceof Bytes && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            BytesUtil.parse8bit_SB1((Bytes)bytes, (StringBuilder)appendable, utflen);
        } else {
            BytesUtil.parse8bit1(bytes, appendable, utflen);
        }
    }

    public static void parse8bit(long offset, @NotNull RandomDataInput bytesStore, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        if (bytesStore instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            BytesUtil.parse8bit_SB1(offset, (NativeBytesStore)bytesStore, (StringBuilder)appendable, utflen);
        } else {
            BytesUtil.parse8bit1(offset, bytesStore, appendable, utflen);
        }
    }

    public static void parseUTF1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        try {
            int count;
            assert (bytes.readRemaining() >= (long)utflen);
            for (count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                if (c >= 128) {
                    bytes.readSkip(-1L);
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (utflen > count) {
                BytesUtil.parseUTF2(bytes, appendable, utflen, count);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse8bit1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        try {
            assert (bytes.readRemaining() >= (long)utflen);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                appendable.append((char)c);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse8bit1(long offset, @NotNull RandomDataInput bytes, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        try {
            assert (bytes.readRemaining() >= (long)utflen);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte(offset + (long)count);
                appendable.append((char)c);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parseUTF_SB1(@NotNull Bytes bytes, @NotNull StringBuilder sb, int utflen) throws UTFDataFormatRuntimeException {
        try {
            byte c;
            int count = 0;
            if ((long)utflen > bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            NativeBytesStore nbs = (NativeBytesStore)bytes.bytesStore();
            long address = nbs.address + nbs.translate(bytes.readPosition());
            Memory memory = nbs.memory;
            sb.ensureCapacity(utflen);
            char[] chars = (char[])SB_VALUE.get(sb);
            while (count < utflen && (c = memory.readByte(address + (long)count)) >= 0) {
                chars[count++] = (char)c;
            }
            bytes.readSkip(count);
            SB_COUNT.setInt(sb, count);
            if (count < utflen) {
                BytesUtil.parseUTF2(bytes, sb, utflen, count);
            }
        }
        catch (IOException | IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse8bit_SB1(@NotNull Bytes bytes, @NotNull StringBuilder sb, int utflen) throws UTFDataFormatRuntimeException {
        if ((long)utflen > bytes.readRemaining()) {
            throw new BufferUnderflowException();
        }
        NativeBytesStore nbs = (NativeBytesStore)bytes.bytesStore();
        long offset = bytes.readPosition();
        int count = BytesUtil.parse8bit_SB1(offset, nbs, sb, utflen);
        bytes.readSkip(count);
    }

    public static int parse8bit_SB1(long offset, NativeBytesStore nbs, @NotNull StringBuilder sb, int utflen) {
        try {
            long address = nbs.address + nbs.translate(offset);
            Memory memory = nbs.memory;
            sb.ensureCapacity(utflen);
            char[] chars = (char[])SB_VALUE.get(sb);
            int count = 0;
            while (count < utflen) {
                int c = memory.readByte(address + (long)count) & 0xFF;
                chars[count++] = (char)c;
            }
            SB_COUNT.setInt(sb, count);
            return count;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    static void parseUTF2(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen, int count) throws IOException {
        block5: while (count < utflen) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + count + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (count - 1) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw new UTFDataFormatRuntimeException("malformed input around byte " + count);
        }
    }

    @ForceInline
    public static void writeUTF(@NotNull StreamingDataOutput bytes, @Nullable CharSequence str) {
        if (str == null) {
            bytes.writeStopBit(-1L);
        } else {
            long utfLength = BytesUtil.findUTFLength(str);
            bytes.writeStopBit(utfLength);
            BytesUtil.appendUTF(bytes, str, 0, str.length());
        }
    }

    private static long findUTFLength(@NotNull CharSequence str) {
        int strlen = str.length();
        long utflen = strlen;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++utflen;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }

    @NotNull
    public static Bytes asBytes(@NotNull RandomDataOutput bytes, long position, long limit) {
        Bytes sbytes = bytes.bytesForWrite();
        sbytes.writeLimit(limit);
        sbytes.readLimit(limit);
        sbytes.readPosition(position);
        return sbytes;
    }

    public static void appendUTF(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, int offset, int length) {
        BytesUtil.appendUTF0(bytes, str, offset, length);
    }

    private static void appendUTF0(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, int offset, int length) {
        char c;
        int i;
        for (i = 0; i < length && (c = str.charAt(offset + i)) <= '\u007f'; ++i) {
            bytes.writeByte((byte)c);
        }
        while (i < length) {
            c = str.charAt(offset + i);
            BytesUtil.appendUTF(bytes, c);
            ++i;
        }
    }

    public static void append8bit(long offsetInRDO, RandomDataOutput bytes, @NotNull CharSequence str, int offset, int length) {
        if (bytes instanceof VanillaBytes) {
            VanillaBytes vb = (VanillaBytes)bytes;
            if (str instanceof RandomDataInput) {
                vb.write(offsetInRDO, (RandomDataInput)((Object)str), (long)offset, (long)length);
                return;
            }
            if (str instanceof String) {
                vb.write(offsetInRDO, str, offset, length);
                return;
            }
        }
        for (int i = 0; i < length; ++i) {
            int c = str.charAt(offset + i);
            if (c > 255) {
                c = 63;
            }
            bytes.writeUnsignedByte(offsetInRDO + (long)i, c);
        }
    }

    public static void appendUTF(@NotNull StreamingDataOutput bytes, int c) {
        if (c <= 127) {
            bytes.writeByte((byte)c);
        } else if (c <= 2047) {
            bytes.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            bytes.writeByte((byte)(0xE0 | c >> 12 & 0xF));
            bytes.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        } else {
            bytes.writeByte((byte)(0xF0 | c >> 18 & 7));
            bytes.writeByte((byte)(0x80 | c >> 12 & 0x3F));
            bytes.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        }
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, long n) {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.writeByte((byte)(n & 0x7FL));
            return;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.writeByte((byte)(n & 0x7FL | 0x80L));
            out.writeByte((byte)(n >> 7));
            return;
        }
        BytesUtil.writeStopBit0(out, n);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, double d) {
        long n = Double.doubleToRawLongBits(d);
        out.writeByte((byte)(n >>> -7 | 0x80L));
        while (((n <<= 7) & 0x1FFFFFFFFFFFFFFL) != 0L) {
            out.writeByte((byte)(n >>> -7 & 0x7FL | 0x80L));
        }
        out.writeByte((byte)(n >>> -7 & 0x7FL));
    }

    public static double readStopBitDouble(@NotNull StreamingDataInput in) {
        byte b;
        long n = 0L;
        int shift = 57;
        do {
            b = in.readByte();
            n |= shift > 0 ? (long)(b & 0x7F) << shift : (long)(b >> -shift);
            shift -= 7;
        } while (b < 0);
        return Double.longBitsToDouble(n);
    }

    public static int stopBitLength(long n) {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        return BytesUtil.stopBitlength0(n);
    }

    static void writeStopBit0(@NotNull StreamingDataOutput out, long n) {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.writeByte((byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.writeByte((byte)n);
        } else {
            out.writeByte((byte)(0x80L | n));
            out.writeByte((byte)0);
        }
    }

    static int stopBitlength0(long n) {
        int len = 0;
        if (n < 0L) {
            len = 1;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n >>>= 7) != 0L) {
            ++len;
        }
        return len + 1;
    }

    public static String toDebugString(@NotNull RandomDataInput bytes, long maxLength) {
        StringBuilder sb = new StringBuilder(200);
        long position = bytes.readPosition();
        sb.append("[").append("pos: ").append(position).append(", rlim: ").append(bytes.readLimit()).append(", wlim: ").append(BytesUtil.asSize(bytes.writeLimit())).append(", cap: ").append(BytesUtil.asSize(bytes.capacity())).append(" ] ");
        BytesUtil.toString(bytes, sb, position - maxLength, position, position + maxLength);
        return sb.toString();
    }

    @NotNull
    public static Object asSize(long size) {
        return size == Long.MAX_VALUE ? "8EiB" : Long.valueOf(size);
    }

    public static String to8bitString(@NotNull BytesStore bytes) {
        long pos = bytes.readPosition();
        int len = Maths.toInt32((long)bytes.readRemaining());
        char[] chars = new char[len];
        if (bytes instanceof VanillaBytes) {
            ((VanillaBytes)bytes).read8Bit(chars, len);
        } else {
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)bytes.readUnsignedByte(pos + (long)i);
            }
        }
        return BytesUtil.newString(chars);
    }

    private static String newString(char[] chars) {
        try {
            return STRING_CONSTRUCTOR.newInstance(chars, true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String toString(@NotNull RandomDataInput bytes) {
        StringBuilder sb = new StringBuilder(200);
        BytesUtil.toString(bytes, sb);
        return sb.toString();
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull Appendable sb, long start, long position, long end) {
        try {
            if (start < 0L) {
                start = 0L;
            }
            if (position > start) {
                long last = Math.min(position, bytes.readLimit());
                for (long i = start; i < last; ++i) {
                    sb.append(bytes.printable(i));
                }
                sb.append('\u2016');
                if (position >= bytes.readLimit()) {
                    return;
                }
            }
            if (end > bytes.readLimit()) {
                end = bytes.readLimit();
            }
            for (long i = position; i < end; ++i) {
                sb.append(bytes.printable(i));
            }
        }
        catch (IOException e) {
            try {
                sb.append(e.toString());
            }
            catch (IOException e1) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull StringBuilder sb) {
        bytes.reserve();
        assert (bytes.start() <= bytes.readPosition());
        assert (bytes.readPosition() <= bytes.readLimit());
        assert (bytes.readLimit() <= bytes.realCapacity());
        for (long i = bytes.readPosition(); i < bytes.readLimit(); ++i) {
            sb.append((char)bytes.readUnsignedByte(i));
        }
        bytes.release();
    }

    @ForceInline
    public static long readStopBit(@NotNull StreamingDataInput in) {
        long l = in.readByte();
        if (l >= 0L) {
            return l;
        }
        return BytesUtil.readStopBit0(in, l);
    }

    static long readStopBit0(@NotNull StreamingDataInput in, long l) {
        long b;
        l &= 0x7FL;
        int count = 7;
        while ((b = (long)in.readByte()) < 0L) {
            l |= (b & 0x7FL) << count;
            count += 7;
        }
        if (b != 0L) {
            if (count > 56) {
                throw new IllegalStateException("Cannot read more than 9 stop bits of positive value");
            }
            return l | b << count;
        }
        if (count > 63) {
            throw new IllegalStateException("Cannot read more than 10 stop bits of negative value");
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static <S extends ByteStringAppender> void append(@NotNull S out, long num) {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.write(MIN_VALUE_TEXT);
                return;
            }
            out.writeByte((byte)45);
            num = -num;
        }
        if (num == 0L) {
            out.writeByte((byte)48);
        } else {
            BytesUtil.appendLong0(out, num);
        }
    }

    public static void append(@NotNull RandomDataOutput out, long offset, long num, int digits) {
        boolean negative = num < 0L;
        num = Math.abs(num);
        for (int i = digits - 1; i > 0; --i) {
            out.writeByte(offset + (long)i, (byte)(num % 10L + 48L));
            num /= 10L;
        }
        if (negative) {
            if (num != 0L) {
                BytesUtil.numberTooLarge(digits);
            }
            out.writeByte(offset, 45);
        } else {
            if (num > 9L) {
                BytesUtil.numberTooLarge(digits);
            }
            out.writeByte(offset, (byte)(num % 10L + 48L));
        }
    }

    private static void numberTooLarge(int digits) {
        throw new IllegalArgumentException("Number too large for " + digits + "digits");
    }

    private static void appendLong0(@NotNull StreamingDataOutput out, long num) {
        byte[] numberBuffer = NUMBER_BUFFER.get();
        int endIndex = BytesUtil.appendLong1(numberBuffer, num);
        out.write(numberBuffer, endIndex, numberBuffer.length - endIndex);
    }

    private static int appendLong1(byte[] numberBuffer, long num) {
        numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        numberBuffer[2] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 2;
        }
        numberBuffer[1] = (byte)(num % 10L + 48L);
        return 1;
    }

    public static void append(@NotNull StreamingDataOutput out, double d) {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            out.writeByte((byte)45);
        }
        if (exp == 0 && mantissa == 0L) {
            out.writeByte((byte)48);
            return;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                out.write(Infinity);
            } else {
                out.write(NaN);
            }
            return;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                BytesUtil.appendLong0(out, intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    out.writeByte((byte)46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        out.writeByte((byte)(48L + num));
                        double parsedValue = BytesUtil.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                }
                return;
            }
            out.writeByte((byte)48);
            out.writeByte((byte)46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    out.writeByte((byte)48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                out.writeByte((byte)c);
                mantissa -= num << precision;
                double parsedValue = BytesUtil.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        BytesUtil.appendLong0(out, val2);
        for (int i = 0; i < digits; ++i) {
            out.writeByte((byte)48);
        }
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    @ForceInline
    @Nullable
    public static String readUTF\u0394(@NotNull StreamingDataInput in) {
        StringBuilder sb = SBP.acquireStringBuilder();
        return in.readUTF\u0394(sb) ? SI.intern((CharSequence)sb) : null;
    }

    @ForceInline
    @Nullable
    public static String read8bit(@NotNull StreamingDataInput in) {
        StringBuilder sb = SBP.acquireStringBuilder();
        return in.read8bit(sb) ? SI.intern((CharSequence)sb) : null;
    }

    @ForceInline
    @NotNull
    public static String parseUTF(@NotNull StreamingDataInput bytes, @NotNull StopCharTester tester) {
        StringBuilder utfReader = SBP.acquireStringBuilder();
        BytesUtil.parseUTF(bytes, (Appendable)utfReader, tester);
        return SI.intern((CharSequence)utfReader);
    }

    @ForceInline
    public static void parseUTF(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharTester tester) {
        try {
            if (builder instanceof StringBuilder && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore) {
                Bytes vb = (Bytes)bytes;
                StringBuilder sb = (StringBuilder)builder;
                sb.setLength(0);
                BytesUtil.readUTF_SB1(vb, sb, tester);
            } else {
                BytesUtil.setLength(builder, 0);
                BytesUtil.readUTF1(bytes, builder, tester);
            }
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private static void readUTF_SB1(@NotNull Bytes bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws IOException {
        byte c;
        int i;
        NativeBytesStore nb = (NativeBytesStore)bytes.bytesStore();
        int len = Maths.toInt32((long)bytes.readRemaining());
        long address = nb.address + nb.translate(bytes.readPosition());
        Memory memory = nb.memory;
        for (i = 0; i < len && (c = memory.readByte(address + (long)i)) >= 0; ++i) {
            if (tester.isStopChar(c)) {
                bytes.readSkip(i + 1);
                return;
            }
            appendable.append((char)c);
        }
        bytes.readSkip(i);
        if (i < len) {
            BytesUtil.readUTF_SB2(bytes, appendable, tester);
        }
    }

    private static void readUTF_SB2(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws UTFDataFormatException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    private static void readUTF1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException {
        int len = Maths.toInt32((long)bytes.readRemaining());
        while (len-- > 0) {
            int c = bytes.readUnsignedByte();
            if (c >= 128) {
                bytes.readSkip(-1L);
                break;
            }
            if (tester.isStopChar(c)) {
                return;
            }
            appendable.append((char)c);
        }
        if (len <= 0) {
            return;
        }
        BytesUtil.readUTF2(bytes, appendable, tester);
    }

    private static void readUTF2(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    @ForceInline
    public static void parseUTF(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharsTester tester) {
        BytesUtil.setLength(builder, 0);
        try {
            BytesUtil.readUTFAndAppend(bytes, builder, tester);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void readUTFAndAppend(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharsTester tester) throws IOException {
        int c;
        block13: {
            do {
                if ((c = bytes.readUnsignedByte()) >= 128) break block13;
                if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                    return;
                }
                appendable.append((char)c);
            } while (bytes.readRemaining() != 0L);
            return;
        }
        bytes.readSkip(-1L);
        block6: while (true) {
            c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c3);
                    continue block6;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharsTester tester) {
        builder.setLength(0);
        BytesUtil.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes builder, @NotNull StopCharsTester tester) {
        builder.readPosition(0L);
        BytesUtil.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharTester tester) {
        builder.setLength(0);
        BytesUtil.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes builder, @NotNull StopCharTester tester) {
        builder.readPosition(0L);
        BytesUtil.read8bitAndAppend(bytes, builder, tester);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes bytes2, @NotNull StopCharTester tester) {
        int ch = bytes.readUnsignedByte();
        do {
            int next;
            if (tester.isStopChar(ch)) {
                bytes.readSkip(-1L);
                return;
            }
            bytes2.writeUnsignedByte(ch);
            ch = next = bytes.readUnsignedByte();
        } while (bytes.readRemaining() > 1L);
        if (tester.isStopChar(ch)) {
            bytes.readSkip(-1L);
            return;
        }
        bytes2.writeUnsignedByte(ch);
    }

    public static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharsTester tester) {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte(), bytes.peekUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes bytes2, @NotNull StopCharsTester tester) {
        int ch = bytes.readUnsignedByte();
        do {
            int next;
            if (tester.isStopChar(ch, next = bytes.readUnsignedByte())) {
                bytes.readSkip(-1L);
                return;
            }
            bytes2.writeUnsignedByte(ch);
            ch = next;
        } while (bytes.readRemaining() > 1L);
        if (tester.isStopChar(ch, -1)) {
            bytes.readSkip(-1L);
            return;
        }
        bytes2.writeUnsignedByte(ch);
    }

    public static double parseDouble(@NotNull StreamingDataInput in) {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        int ch = in.readUnsignedByte();
        switch (ch) {
            case 78: {
                if (BytesUtil.compareRest(in, "aN")) {
                    return Double.NaN;
                }
                in.readSkip(-1L);
                return Double.NaN;
            }
            case 73: {
                if (BytesUtil.compareRest(in, "nfinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                in.readSkip(-1L);
                return Double.NaN;
            }
            case 45: {
                if (BytesUtil.compareRest(in, "Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                negative = true;
                ch = in.readUnsignedByte();
            }
        }
        while (true) {
            if (ch >= 48 && ch <= 57) {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
            } else {
                if (ch != 46) break;
                decimalPlaces = 0;
            }
            if (in.readRemaining() == 0L) break;
            ch = in.readUnsignedByte();
        }
        return BytesUtil.asDouble(value, exp, negative, decimalPlaces);
    }

    static boolean compareRest(@NotNull StreamingDataInput in, @NotNull String s) {
        if ((long)s.length() > in.readRemaining()) {
            return false;
        }
        long position = in.readPosition();
        for (int i = 0; i < s.length(); ++i) {
            if (in.readUnsignedByte() == s.charAt(i)) continue;
            in.readPosition(position);
            return false;
        }
        return true;
    }

    @ForceInline
    public static long parseLong(@NotNull StreamingDataInput in) {
        long num = 0L;
        boolean negative = false;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b != 93 && b != 125) break;
            in.readSkip(-1L);
            break;
        }
        return negative ? -num : num;
    }

    public static long parseLong(@NotNull RandomDataInput in, long offset) {
        long num = 0L;
        boolean negative = false;
        while (true) {
            int b;
            if ((b = in.readUnsignedByte(offset++)) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        return negative ? -num : num;
    }

    public static boolean skipTo(@NotNull ByteStringParser parser, @NotNull StopCharTester tester) {
        while (parser.readRemaining() > 0L) {
            int ch = parser.readUnsignedByte();
            if (!tester.isStopChar(ch)) continue;
            return true;
        }
        return false;
    }

    public static int getAndAddInt(@NotNull BytesStore in, long offset, int adding) {
        int value;
        while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value + adding)) {
        }
        return value;
    }

    public static long getAndAddLong(@NotNull BytesStore in, long offset, long adding) {
        long value;
        while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value + adding)) {
        }
        return value;
    }

    public static int asInt(@NotNull String str) {
        ByteBuffer bb = ByteBuffer.wrap(str.getBytes(StandardCharsets.ISO_8859_1)).order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    public static String toHexString(@NotNull Bytes bytes) {
        return BytesUtil.toHexString(bytes, bytes.readPosition(), bytes.readRemaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHexString(@NotNull Bytes bytes, long offset, long len) {
        if (len == 0L) {
            return "";
        }
        int width = 16;
        int[] lastLine = new int[width];
        String sep = "";
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readLimit(offset + len);
            bytes.readPosition(offset);
            StringBuilder builder = new StringBuilder();
            long start = offset / (long)width * (long)width;
            long end = (offset + len + (long)width - 1L) / (long)width * (long)width;
            for (long i = start; i < end; i += (long)width) {
                int ch;
                int j;
                if (i + (long)width < end) {
                    boolean same = true;
                    for (j = 0; j < width && i + (long)j < offset + len; ++j) {
                        ch = bytes.readUnsignedByte(i + (long)j);
                        same &= ch == lastLine[j];
                        lastLine[j] = ch;
                    }
                    if (i > start && same) {
                        sep = "........\n";
                        continue;
                    }
                }
                builder.append(sep);
                sep = "";
                String str = Long.toHexString(i);
                for (j = str.length(); j < 8; ++j) {
                    builder.append('0');
                }
                builder.append(str);
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < start || i + (long)j >= offset + len) {
                        builder.append("   ");
                        continue;
                    }
                    builder.append(' ');
                    ch = bytes.readUnsignedByte(i + (long)j);
                    builder.append(HEXI_DECIMAL[ch >> 4]);
                    builder.append(HEXI_DECIMAL[ch & 0xF]);
                }
                builder.append(' ');
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < start || i + (long)j >= offset + len) {
                        builder.append(' ');
                        continue;
                    }
                    ch = bytes.readUnsignedByte(i + (long)j);
                    if (ch < 32 || ch > 126) {
                        ch = 183;
                    }
                    builder.append((char)ch);
                }
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }

    public static void setCharAt(@NotNull Appendable sb, int index, char ch) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setCharAt(index, ch);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).writeByte(index, ch);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    @ForceInline
    public static void setLength(@NotNull Appendable sb, int newLength) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setLength(newLength);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).readPosition(newLength);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, double value) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, long value) {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(@NotNull ACS sb, String str) {
        try {
            sb.append(str);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence) {
            return StringUtils.isEqual((CharSequence)((CharSequence)o1), (CharSequence)((CharSequence)o2));
        }
        return o1 != null && o1.equals(o2);
    }

    public static void appendTimeMillis(@NotNull ByteStringAppender b, long timeInMS) {
        int hours = (int)(timeInMS / 3600000L);
        if (hours > 99) {
            b.append(hours);
        } else {
            b.writeByte((byte)(hours / 10 + 48));
            b.writeByte((byte)(hours % 10 + 48));
        }
        b.writeByte((byte)58);
        int minutes = (int)(timeInMS / 60000L % 60L);
        b.writeByte((byte)(minutes / 10 + 48));
        b.writeByte((byte)(minutes % 10 + 48));
        b.writeByte((byte)58);
        int seconds = (int)(timeInMS / 1000L % 60L);
        b.writeByte((byte)(seconds / 10 + 48));
        b.writeByte((byte)(seconds % 10 + 48));
        b.writeByte((byte)46);
        int millis = (int)(timeInMS % 1000L);
        b.writeByte((byte)(millis / 100 + 48));
        b.writeByte((byte)(millis / 10 % 10 + 48));
        b.writeByte((byte)(millis % 10 + 48));
    }

    public static boolean equalBytesAny(@NotNull BytesStore b1, @NotNull BytesStore b2, long remaining) {
        int i2;
        long i;
        BytesStore bs1 = b1.bytesStore();
        BytesStore bs2 = b2.bytesStore();
        for (i = 0L; i < remaining - 7L; ++i) {
            long l2;
            long l1 = bs1.readLong(b1.readPosition() + i);
            if (l1 == (l2 = bs2.readLong(b2.readPosition() + i))) continue;
            return false;
        }
        if (i < remaining - 3L) {
            int i1 = bs1.readInt(b1.readPosition() + i);
            if (i1 != (i2 = bs2.readInt(b2.readPosition() + i))) {
                return false;
            }
            i += 4L;
        }
        while (i < remaining) {
            byte i1 = bs1.readByte(b1.readPosition() + i);
            if (i1 != (i2 = (int)bs2.readByte(b2.readPosition() + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void appendDateMillis(@NotNull ByteStringAppender b, long timeInMS) {
        DateCache dateCache = dateCacheTL.get();
        if (dateCache == null) {
            dateCache = new DateCache();
            dateCacheTL.set(dateCache);
        }
        long date = timeInMS / 86400000L;
        if (dateCache.lastDay != date) {
            DateCache.access$102(dateCache, dateCache.dateFormat.format(new Date(timeInMS)).getBytes(StandardCharsets.ISO_8859_1));
            dateCache.lastDay = date;
        } else assert (dateCache.lastDateStr != null);
        b.write(dateCache.lastDateStr);
    }

    public static <E extends Enum<E>, S extends StreamingDataInput<S>> E readEnum(StreamingDataInput input, Class<E> eClass) {
        StringBuilder sb = SBP.acquireStringBuilder();
        input.read8bit(sb);
        return (E)((EnumInterner)EnumInterner.ENUM_INTERNER.get(eClass)).intern((CharSequence)sb);
    }

    public static void write(@NotNull BytesStore bytes, long offset, long length, StreamingDataOutput sdo) {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            sdo.writeLong(bytes.readLong(offset + i));
        }
        if (i < length - 3L) {
            sdo.writeInt(bytes.readInt(offset + i));
            i += 4L;
        }
        while (i < length) {
            sdo.writeByte(bytes.readByte(offset + i));
            ++i;
        }
    }

    static {
        $VALUES = new BytesUtil[0];
        HEXI_DECIMAL = "0123456789ABCDEF".toCharArray();
        MIN_VALUE_TEXT = "-9223372036854775808".getBytes();
        SBP = new StringBuilderPool();
        SI = new StringInterner(1024);
        Infinity = "Infinity".getBytes();
        NaN = "NaN".getBytes();
        NUMBER_BUFFER = ThreadLocal.withInitial(() -> new byte[20]);
        dateCacheTL = new ThreadLocal();
        try {
            ClassAliasPool.CLASS_ALIASES.addAlias(BytesStore.class, "!binary");
            STRING_CONSTRUCTOR = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            STRING_CONSTRUCTOR.setAccessible(true);
            SB_VALUE = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("value");
            SB_VALUE.setAccessible(true);
            SB_COUNT = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("count");
            SB_COUNT.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static class DateCache {
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        private long lastDay = Long.MIN_VALUE;
        @Nullable
        private byte[] lastDateStr = null;

        DateCache() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        static /* synthetic */ byte[] access$102(DateCache x0, byte[] x1) {
            x0.lastDateStr = x1;
            return x1;
        }
    }
}

