/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StreamingDataInput<S extends StreamingDataInput<S>>
extends StreamingCommon<S> {
    public S readPosition(long var1);

    public S readLimit(long var1);

    default public void readWithLength(long length, @NotNull Consumer<S> bytesConsumer) {
        this.parseWithLength(length, s -> {
            bytesConsumer.accept(s);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R parseWithLength(long length, @NotNull Function<S, R> bytesConsumer) {
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            R r = bytesConsumer.apply(this);
            return r;
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    @NotNull
    default public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return StreamingDataInput.this.read(b, off, len);
            }

            @Override
            public int read() throws IOException {
                return StreamingDataInput.this.readRemaining() > 0L ? StreamingDataInput.this.readUnsignedByte() : -1;
            }
        };
    }

    default public long readStopBit() {
        return BytesUtil.readStopBit(this);
    }

    default public double readStopBitDouble() {
        return BytesUtil.readStopBitDouble(this);
    }

    default public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte();

    default public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public short readShort();

    default public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readInt();

    default public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong();

    public float readFloat();

    public double readDouble();

    @Nullable
    default public String readUTF\u0394() {
        return BytesUtil.readUTF\u0394(this);
    }

    @Nullable
    default public String read8bit() {
        return BytesUtil.read8bit(this);
    }

    default public <ACS extends Appendable & CharSequence> boolean readUTF\u0394(@NotNull ACS sb) throws UTFDataFormatRuntimeException {
        BytesUtil.setLength(sb, 0);
        long len0 = BytesUtil.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        BytesUtil.parseUTF(this, sb, len);
        return true;
    }

    default public boolean read8bit(@NotNull Bytes b) throws UTFDataFormatRuntimeException {
        b.clear();
        long len0 = BytesUtil.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        b.write((BytesStore)((Object)this), this.readPosition(), len);
        this.readSkip(len);
        return true;
    }

    default public <ACS extends Appendable & CharSequence> boolean read8bit(@NotNull ACS sb) throws UTFDataFormatRuntimeException {
        BytesUtil.setLength(sb, 0);
        long len0 = BytesUtil.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        BytesUtil.parse8bit(this, sb, len);
        return true;
    }

    default public boolean read8bit(StringBuilder sb) {
        sb.setLength(0);
        long len0 = BytesUtil.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        BytesUtil.parse8bit(this, (Appendable)sb, len);
        return true;
    }

    default public void read(@NotNull byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.readByte();
        }
    }

    default public int read(@NotNull byte[] bytes, int off, int len) {
        int len2 = (int)Math.min((long)len, this.readRemaining());
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = this.readByte();
        }
        return len2;
    }

    default public void read(@NotNull ByteBuffer buffer) {
        for (int i = (int)Math.min(this.readRemaining(), (long)buffer.remaining()); i > 0; --i) {
            buffer.put(this.readByte());
        }
    }

    public int readVolatileInt();

    public long readVolatileLong();

    public int peekUnsignedByte();

    public void nativeRead(long var1, long var3);

    default public <E extends Enum<E>> E readEnum(Class<E> eClass) {
        return BytesUtil.readEnum(this, eClass);
    }
}

