/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.UnsafeMemory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class NativeBytesStore<Underlying>
implements BytesStore<NativeBytesStore<Underlying>, Underlying> {
    private static final long MEMORY_MAPPED_SIZE = 131072L;
    private final Cleaner cleaner;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private final boolean elastic;
    protected long address;
    private volatile Underlying underlyingObject;
    private long maximumLimit;

    private NativeBytesStore(ByteBuffer bb, boolean elastic) {
        this.elastic = elastic;
        this.underlyingObject = bb;
        this.address = ((DirectBuffer)((Object)bb)).address();
        this.maximumLimit = bb.capacity();
        this.cleaner = ((DirectBuffer)((Object)bb)).cleaner();
    }

    protected NativeBytesStore(long address, long maximumLimit, Runnable deallocator, boolean elastic) {
        this.address = address;
        this.maximumLimit = maximumLimit;
        this.cleaner = Cleaner.create((Object)this, (Runnable)deallocator);
        this.underlyingObject = null;
        this.elastic = elastic;
    }

    static NativeBytesStore<ByteBuffer> wrap(ByteBuffer bb) {
        return new NativeBytesStore<ByteBuffer>(bb, false);
    }

    public static NativeBytesStore<Void> nativeStore(long capacity) {
        return NativeBytesStore.of(capacity, true, true);
    }

    private static NativeBytesStore<Void> of(long capacity, boolean zeroOut, boolean elastic) {
        long address = UnsafeMemory.MEMORY.allocate(capacity);
        if (zeroOut || capacity < 131072L) {
            UnsafeMemory.MEMORY.setMemory(address, capacity, (byte)0);
            UnsafeMemory.MEMORY.storeFence();
        }
        Deallocator deallocator = new Deallocator(address);
        return new NativeBytesStore<Void>(address, capacity, deallocator, elastic);
    }

    public static NativeBytesStore<Void> nativeStoreWithFixedCapacity(long capacity) {
        return NativeBytesStore.of(capacity, true, false);
    }

    public static NativeBytesStore<Void> lazyNativeBytesStoreWithFixedCapacity(long capacity) {
        return NativeBytesStore.of(capacity, false, false);
    }

    public static NativeBytesStore<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer(OS.pageSize());
    }

    public static NativeBytesStore<ByteBuffer> elasticByteBuffer(int size) {
        return new NativeBytesStore<ByteBuffer>(ByteBuffer.allocateDirect(size), true);
    }

    @Override
    public Bytes<Underlying> bytes() {
        return this.elastic ? new NativeBytes((BytesStore)this) : new VanillaBytes((BytesStore)this);
    }

    @Override
    public long realCapacity() {
        return this.maximumLimit;
    }

    @Override
    public long capacity() {
        return this.maximumLimit;
    }

    @Override
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    public Access<Underlying> access() {
        return Access.nativeAccess();
    }

    @Override
    public NativeBytesStore<Underlying> zeroOut(long start, long end) {
        if (start < 0L || end > this.limit()) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end + ", limit=" + this.limit());
        }
        if (start >= end) {
            return this;
        }
        UnsafeMemory.MEMORY.setMemory(this.address + this.translate(start), end - start, (byte)0);
        return this;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        return UnsafeMemory.MEMORY.compareAndSwapInt(this.address + this.translate(offset), expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        return UnsafeMemory.MEMORY.compareAndSwapLong(this.address + this.translate(offset), expected, value);
    }

    private long translate(long offset) {
        long offset2 = offset - this.start();
        if (offset2 < 0L || offset2 > this.capacity()) {
            throw new IllegalArgumentException("Offset out of bounds");
        }
        return offset2;
    }

    public void reserve() {
        this.refCount.reserve();
    }

    public void release() {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public byte readByte(long offset) {
        return UnsafeMemory.MEMORY.readByte(this.address + this.translate(offset));
    }

    @Override
    public short readShort(long offset) {
        return UnsafeMemory.MEMORY.readShort(this.address + this.translate(offset));
    }

    @Override
    public int readInt(long offset) {
        return UnsafeMemory.MEMORY.readInt(this.address + this.translate(offset));
    }

    @Override
    public long readLong(long offset) {
        return UnsafeMemory.MEMORY.readLong(this.address + this.translate(offset));
    }

    @Override
    public float readFloat(long offset) {
        return UnsafeMemory.MEMORY.readFloat(this.address + this.translate(offset));
    }

    @Override
    public double readDouble(long offset) {
        return UnsafeMemory.MEMORY.readDouble(this.address + this.translate(offset));
    }

    @Override
    public int readVolatileInt(long offset) {
        return UnsafeMemory.MEMORY.readVolatileInt(this.address + this.translate(offset));
    }

    @Override
    public long readVolatileLong(long offset) {
        return UnsafeMemory.MEMORY.readVolatileLong(this.address + this.translate(offset));
    }

    @Override
    public NativeBytesStore<Underlying> writeByte(long offset, byte i8) {
        UnsafeMemory.MEMORY.writeByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeShort(long offset, short i16) {
        UnsafeMemory.MEMORY.writeShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeInt(long offset, int i32) {
        UnsafeMemory.MEMORY.writeInt(this.address + this.translate(offset), i32);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeOrderedInt(long offset, int i) {
        UnsafeMemory.MEMORY.writeOrderedInt(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeLong(long offset, long i64) {
        UnsafeMemory.MEMORY.writeLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeOrderedLong(long offset, long i) {
        UnsafeMemory.MEMORY.writeOrderedLong(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeFloat(long offset, float f) {
        UnsafeMemory.MEMORY.writeFloat(this.address + this.translate(offset), f);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeDouble(long offset, double d) {
        UnsafeMemory.MEMORY.writeDouble(this.address + this.translate(offset), d);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        UnsafeMemory.MEMORY.copyMemory(bytes, offset, this.address + this.translate(offsetInRDO), length);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> write(long offsetInRDO, ByteBuffer bytes, int offset, int length) {
        if (bytes.isDirect()) {
            UnsafeMemory.MEMORY.copyMemory(((DirectBuffer)((Object)bytes)).address(), this.address + this.translate(offsetInRDO), (long)length);
        } else {
            UnsafeMemory.MEMORY.copyMemory(bytes.array(), offset, this.address + this.translate(offsetInRDO), length);
        }
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> write(long offsetInRDO, Bytes bytes, long offset, long length) {
        Access.copy(bytes.access(), bytes.accessHandle(), bytes.accessOffset(offset), this.access(), this.accessHandle(), this.accessOffset(offsetInRDO), length);
        return this;
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public Underlying accessHandle() {
        return null;
    }

    @Override
    public long accessOffset(long randomOffset) {
        return this.address + this.translate(randomOffset);
    }

    protected void performRelease() {
        this.cleaner.clean();
    }

    public boolean isElastic() {
        return this.elastic;
    }

    public String toString() {
        return BytesUtil.toDebugString(this, 1024L);
    }

    static class Deallocator
    implements Runnable {
        private volatile long address;

        Deallocator(long address) {
            assert (address != 0L);
            this.address = address;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            this.address = 0L;
            UnsafeMemory.MEMORY.freeMemory(this.address);
        }
    }
}

