/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.BytesAccesses;
import net.openhft.chronicle.bytes.BytesStore;

final class BytesAccessors {
    private BytesAccessors() {
    }

    static class Generic<S extends BytesStore>
    implements Accessor.Full<S, S> {
        static final Generic INSTANCE = new Generic();

        Generic() {
        }

        @Override
        public Access<S> access(S source) {
            return BytesAccesses.Full.INSTANCE;
        }

        @Override
        public S handle(S source) {
            return source;
        }

        @Override
        public long offset(S source, long index) {
            return index;
        }
    }

    static class Unchecked<S extends BytesStore<S, U>, U>
    implements Accessor.Full<S, U> {
        static final Generic INSTANCE = new Generic();

        Unchecked() {
        }

        @Override
        public Access<U> access(S source) {
            return source.access();
        }

        @Override
        public U handle(S source) {
            return (U)source.accessHandle();
        }

        @Override
        public long offset(S source, long index) {
            return source.accessOffset(index);
        }
    }
}

