/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.NativeAccess;

final class ArrayAccessors {
    static final long BOOLEAN_BASE;
    static final long BYTE_BASE;
    static final long CHAR_BASE;
    static final long SHORT_BASE;
    static final long INT_BASE;
    static final long LONG_BASE;
    static final long FLOAT_BASE;
    static final long DOUBLE_BASE;

    private ArrayAccessors() {
    }

    static {
        try {
            BOOLEAN_BASE = NativeAccess.U.arrayBaseOffset(boolean[].class);
            BYTE_BASE = NativeAccess.U.arrayBaseOffset(byte[].class);
            CHAR_BASE = NativeAccess.U.arrayBaseOffset(char[].class);
            SHORT_BASE = NativeAccess.U.arrayBaseOffset(short[].class);
            INT_BASE = NativeAccess.U.arrayBaseOffset(int[].class);
            LONG_BASE = NativeAccess.U.arrayBaseOffset(long[].class);
            FLOAT_BASE = NativeAccess.U.arrayBaseOffset(float[].class);
            DOUBLE_BASE = NativeAccess.U.arrayBaseOffset(double[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum Double implements Accessor.Full<double[], double[]>
    {
        INSTANCE;


        @Override
        public Access<double[]> access(double[] source) {
            return NativeAccess.instance();
        }

        @Override
        public double[] handle(double[] source) {
            return source;
        }

        @Override
        public long offset(double[] source, long index) {
            return DOUBLE_BASE + index * 8L;
        }

        @Override
        public long size(long size) {
            return size * 8L;
        }
    }

    static enum Float implements Accessor.Full<float[], float[]>
    {
        INSTANCE;


        @Override
        public Access<float[]> access(float[] source) {
            return NativeAccess.instance();
        }

        @Override
        public float[] handle(float[] source) {
            return source;
        }

        @Override
        public long offset(float[] source, long index) {
            return FLOAT_BASE + index * 4L;
        }

        @Override
        public long size(long size) {
            return size * 4L;
        }
    }

    static enum Long implements Accessor.Full<long[], long[]>
    {
        INSTANCE;


        @Override
        public Access<long[]> access(long[] source) {
            return NativeAccess.instance();
        }

        @Override
        public long[] handle(long[] source) {
            return source;
        }

        @Override
        public long offset(long[] source, long index) {
            return LONG_BASE + index * 8L;
        }

        @Override
        public long size(long size) {
            return size * 8L;
        }
    }

    static enum Int implements Accessor.Full<int[], int[]>
    {
        INSTANCE;


        @Override
        public Access<int[]> access(int[] source) {
            return NativeAccess.instance();
        }

        @Override
        public int[] handle(int[] source) {
            return source;
        }

        @Override
        public long offset(int[] source, long index) {
            return INT_BASE + index * 4L;
        }

        @Override
        public long size(long size) {
            return size * 4L;
        }
    }

    static enum Short implements Accessor.Full<short[], short[]>
    {
        INSTANCE;


        @Override
        public Access<short[]> access(short[] source) {
            return NativeAccess.instance();
        }

        @Override
        public short[] handle(short[] source) {
            return source;
        }

        @Override
        public long offset(short[] source, long index) {
            return SHORT_BASE + index * 2L;
        }

        @Override
        public long size(long size) {
            return size * 2L;
        }
    }

    static enum Char implements Accessor.Full<char[], char[]>
    {
        INSTANCE;


        @Override
        public Access<char[]> access(char[] source) {
            return NativeAccess.instance();
        }

        @Override
        public char[] handle(char[] source) {
            return source;
        }

        @Override
        public long offset(char[] source, long index) {
            return CHAR_BASE + index * 2L;
        }

        @Override
        public long size(long size) {
            return size * 2L;
        }
    }

    static enum Byte implements Accessor.Full<byte[], byte[]>
    {
        INSTANCE;


        @Override
        public Access<byte[]> access(byte[] source) {
            return NativeAccess.instance();
        }

        @Override
        public byte[] handle(byte[] source) {
            return source;
        }

        @Override
        public long offset(byte[] source, long index) {
            return BYTE_BASE + index;
        }
    }

    static enum Boolean implements Accessor.Full<boolean[], boolean[]>
    {
        INSTANCE;


        @Override
        public Access<boolean[]> access(boolean[] source) {
            return NativeAccess.instance();
        }

        @Override
        public boolean[] handle(boolean[] source) {
            return source;
        }

        @Override
        public long offset(boolean[] source, long index) {
            return BOOLEAN_BASE + index;
        }
    }
}

