/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.OS;

public class MappedBytes
extends AbstractBytes {
    private final MappedFile mappedFile;

    MappedBytes(MappedFile mappedFile) {
        super(NoBytesStore.noBytesStore());
        this.mappedFile = mappedFile;
        this.clear();
    }

    public static MappedBytes mappedBytes(String filename, long chunkSize) throws FileNotFoundException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    public static MappedBytes mappedBytes(File file, long chunkSize) throws FileNotFoundException {
        MappedFile rw = new MappedFile(file, chunkSize, OS.pageSize());
        MappedBytes bytes = new MappedBytes(rw);
        return bytes;
    }

    @Override
    public long capacity() {
        return this.mappedFile == null ? 0L : this.mappedFile.capacity();
    }

    @Override
    public void reserve() throws IllegalStateException {
        super.reserve();
    }

    @Override
    public void release() throws IllegalStateException {
        super.release();
    }

    @Override
    public long refCount() {
        return Math.max(super.refCount(), this.mappedFile.refCount());
    }

    @Override
    protected long readCheckOffset(long offset, int adding) {
        return this.checkOffset(offset);
    }

    @Override
    protected long writeCheckOffset(long offset, long adding) {
        return this.checkOffset(offset);
    }

    private long checkOffset(long offset) {
        if (!this.bytesStore.inStore(offset)) {
            BytesStore oldBS = this.bytesStore;
            try {
                this.bytesStore = this.mappedFile.acquireByteStore(offset);
                oldBS.release();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return offset;
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    public Bytes writeLong(long offset, long i) {
        return super.writeLong(offset, i);
    }

    @Override
    protected void performRelease() {
        super.performRelease();
        this.mappedFile.close();
    }

    @Override
    public boolean isElastic() {
        return true;
    }
}

