/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStoreBytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.ZeroedBytes;
import net.openhft.chronicle.core.ReferenceCounted;

public interface BytesStore<B extends BytesStore<B, Underlying>, Underlying>
extends RandomDataInput<B, Access<Underlying>, Underlying>,
RandomDataOutput<B, Access<Underlying>, Underlying>,
ReferenceCounted {
    public static BytesStore wrap(byte[] bytes) {
        return HeapBytesStore.wrap(ByteBuffer.wrap(bytes));
    }

    public static BytesStore wrap(ByteBuffer bb) {
        return bb.isDirect() ? NativeBytesStore.wrap(bb) : HeapBytesStore.wrap(bb);
    }

    default public Bytes<Underlying> bytes() {
        return this.bytes(UnderflowMode.PADDED);
    }

    default public Bytes bytes(UnderflowMode underflowMode) {
        switch (underflowMode) {
            case BOUNDED: {
                return new BytesStoreBytes(this);
            }
            case ZERO_EXTEND: 
            case PADDED: {
                return new ZeroedBytes(this, underflowMode);
            }
        }
        throw new UnsupportedOperationException("Unknown known mode " + (Object)((Object)underflowMode));
    }

    default public long start() {
        return 0L;
    }

    @Override
    default public long realCapacity() {
        return this.capacity();
    }

    @Override
    public long capacity();

    default public BytesStore with(long position, long length, Consumer<Bytes> bytesConsumer) {
        if (position + length > this.capacity()) {
            throw new BufferUnderflowException();
        }
        BytesStoreBytes bsb = new BytesStoreBytes(this);
        bsb.position(position);
        bsb.limit(position + length);
        bytesConsumer.accept(bsb);
        return this;
    }

    default public boolean inStore(long offset) {
        return this.start() <= offset && offset < this.safeLimit();
    }

    default public long safeLimit() {
        return this.capacity();
    }

    public void storeFence();

    public void loadFence();

    default public void copyTo(BytesStore store) {
        long copy = Math.min(this.capacity(), store.capacity());
        Access.copy(this.access(), this.accessHandle(), this.accessOffset(this.start()), store.access(), store.accessHandle(), store.accessOffset(store.start()), copy);
    }

    public Underlying underlyingObject();

    @Override
    default public boolean isNative() {
        return this.underlyingObject() == null;
    }

    @Override
    default public B zeroOut(long start, long end) {
        if (start < this.start() || end > this.capacity() || end > start) {
            throw new IllegalArgumentException();
        }
        this.access().zeroOut(this.accessHandle(), this.accessOffset(start), end - start);
        return (B)this;
    }

    public boolean compareAndSwapInt(long var1, int var3, int var4);

    public boolean compareAndSwapLong(long var1, long var3, long var5);

    default public int addAndGetInt(long offset, int adding) {
        return BytesUtil.getAndAddInt(this, offset, adding) + adding;
    }

    default public int getAndAddInt(long offset, int adding) {
        return BytesUtil.getAndAddInt(this, offset, adding);
    }

    default public long addAndGetLong(long offset, long adding) {
        return BytesUtil.getAndAddLong(this, offset, adding) + adding;
    }

    default public long getAndAddLong(long offset, long adding) {
        return BytesUtil.getAndAddLong(this, offset, adding);
    }

    @Override
    public Access<Underlying> access();
}

