/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import org.jetbrains.annotations.NotNull;

public interface Bytes<Underlying>
extends BytesStore<Bytes<Underlying>, Underlying>,
StreamingDataInput<Bytes<Underlying>, Access<Underlying>, Underlying>,
StreamingDataOutput<Bytes<Underlying>, Access<Underlying>, Underlying>,
ByteStringParser<Bytes<Underlying>, Access<Underlying>, Underlying>,
ByteStringAppender<Bytes<Underlying>, Access<Underlying>, Underlying>,
CharSequence {
    @Override
    public long position();

    @Deprecated
    public Bytes mark();

    @Deprecated
    public Bytes reset() throws InvalidMarkException;

    @Override
    public Bytes<Underlying> position(long var1);

    @Override
    public long limit();

    @Override
    public Bytes<Underlying> limit(long var1);

    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer().bytes();
    }

    public static Bytes<ByteBuffer> wrap(ByteBuffer byteBuffer) {
        return BytesStore.wrap(byteBuffer).bytes();
    }

    public static Bytes<byte[]> wrap(byte[] byteArray) {
        return BytesStore.wrap(byteArray).bytes();
    }

    @Override
    default public int length() {
        return (int)Math.min(this.remaining(), Integer.MAX_VALUE);
    }

    @Override
    default public char charAt(int offset) {
        return (char)this.readUnsignedByte(this.position() + (long)offset);
    }

    @Override
    default public String subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public boolean isElastic();

    default public void ensureCapacity(long size) {
        throw new UnsupportedOperationException("todo");
    }

    public static String toHex(@NotNull Bytes buffer) {
        return Bytes.toHex(buffer, buffer.position(), buffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHex(@NotNull Bytes buffer, long offset, long len) {
        if (len == 0L) {
            return "";
        }
        long position = buffer.position();
        long limit = buffer.limit();
        try {
            buffer.limit(offset + len);
            buffer.position(offset);
            StringBuilder builder = new StringBuilder("[");
            while (buffer.remaining() > 0L) {
                long pos = buffer.position();
                byte b = buffer.readByte();
                char c = (char)b;
                builder.append(c + "(" + String.format("%02X ", b).trim() + ")[" + pos + "]");
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull Bytes buffer) {
        if (buffer.remaining() == 0L) {
            return "";
        }
        long position = buffer.position();
        long limit = buffer.limit();
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.remaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull ByteBuffer buffer) {
        if (buffer.remaining() == 0) {
            return "";
        }
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.remaining() > 0) {
                builder.append((char)buffer.get());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull Bytes buffer, long position, long len) {
        long pos = buffer.position();
        long limit = buffer.readLimit();
        buffer.position(position);
        buffer.limit(position + len);
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.remaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(pos);
        }
    }

    @Override
    public Access<Underlying> access();
}

