/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.analytics.Analytics;
import net.openhft.chronicle.analytics.internal.AbstractGoogleAnalytics;
import net.openhft.chronicle.analytics.internal.AnalyticsConfiguration;
import net.openhft.chronicle.analytics.internal.HttpUtil;
import org.jetbrains.annotations.NotNull;

final class GoogleAnalytics3
extends AbstractGoogleAnalytics
implements Analytics {
    private static final String URL_STRING = "https://www.google-analytics.com/collect";

    GoogleAnalytics3(@NotNull AnalyticsConfiguration configuration) {
        super(configuration);
    }

    @Override
    void httpSend(@NotNull String eventName, @NotNull Map<String, String> eventParameters) {
        String body = this.bodyFor(eventName, this.clientId(), eventParameters, this.configuration().userProperties());
        HttpUtil.send(URL_STRING, body, this.configuration().errorLogger(), this.configuration().debugLogger());
    }

    private String bodyFor(@NotNull String eventName, @NotNull String clientId, @NotNull Map<String, String> eventParameters, @NotNull Map<String, String> userProperties) {
        String version = Optional.ofNullable(eventParameters.remove("app_version")).orElse("unknown");
        StringJoiner payload = new StringJoiner("&").add("v=" + this.urlEncode("1")).add("ds=" + this.urlEncode("app")).add("tid=" + this.urlEncode(this.configuration().measurementId())).add("cid=" + clientId).add("t=" + this.urlEncode("screenview")).add("ni=" + this.urlEncode("1")).add("cd=" + this.urlEncode(eventName)).add("an=" + this.urlEncode(this.configuration().apiSecret())).add("av=" + this.urlEncode(version));
        LinkedHashMap<String, String> combined = new LinkedHashMap<String, String>(eventParameters);
        combined.putAll(userProperties);
        AtomicInteger cnt = new AtomicInteger();
        combined.entrySet().stream().limit(20L).map(e -> String.format("cd%d=%s", cnt.incrementAndGet(), e.getValue())).forEach(payload::add);
        return payload.toString();
    }
}

