/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class ClientIdUtil {
    private ClientIdUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String acquireClientId(@NotNull String clientIdFileName, @NotNull Consumer<String> debugLogger) {
        Path path = Paths.get(clientIdFileName, new String[0]);
        try (Stream<String> lines = Files.lines(path, StandardCharsets.UTF_8);){
            String string = lines.findFirst().map(UUID::fromString).orElseThrow(NoSuchElementException::new).toString();
            return string;
        }
        catch (Exception ignore) {
            debugLogger.accept("Client id file not present: " + path.toAbsolutePath().toString());
            String id = UUID.randomUUID().toString();
            try {
                Files.write(path, id.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                return id;
            }
            catch (IOException ignore2) {
                debugLogger.accept("Unable to create client id file: " + path.toAbsolutePath().toString());
            }
            return id;
        }
    }
}

