/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.locks;

import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.locks.AbstractReadWriteLockingStrategy;
import net.openhft.chronicle.algo.locks.ReadWriteUpdateWithWaitsLockingStrategy;

public final class VanillaReadWriteUpdateWithWaitsLockingStrategy
extends AbstractReadWriteLockingStrategy
implements ReadWriteUpdateWithWaitsLockingStrategy {
    static final long COUNT_WORD_OFFSET = 0L;
    static final long WAIT_WORD_OFFSET = 4L;
    static final int COUNT_WORD_SHIFT = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 0 : 32;
    static final int WAIT_WORD_SHIFT = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 32 : 0;
    static final int READ_BITS = 30;
    static final int MAX_READ = 0x3FFFFFFF;
    static final int READ_MASK = 0x3FFFFFFF;
    static final int READ_PARTY = 1;
    static final int UPDATE_PARTY = 0x40000000;
    static final int WRITE_LOCKED_COUNT_WORD = Integer.MIN_VALUE;
    static final int MAX_WAIT = Integer.MAX_VALUE;
    static final int WAIT_PARTY = 1;
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private static final ReadWriteUpdateWithWaitsLockingStrategy INSTANCE = new VanillaReadWriteUpdateWithWaitsLockingStrategy();

    private VanillaReadWriteUpdateWithWaitsLockingStrategy() {
    }

    public static ReadWriteUpdateWithWaitsLockingStrategy instance() {
        return INSTANCE;
    }

    private static <T> long getLockWord(ReadAccess<T> access, T t, long offset) {
        return access.readVolatileLong(t, offset);
    }

    private static <T> boolean casLockWord(Access<T> access, T t, long offset, long expected, long x) {
        return access.compareAndSwapLong(t, offset, expected, x);
    }

    private static int countWord(long lockWord) {
        return (int)(lockWord >> COUNT_WORD_SHIFT);
    }

    private static int waitWord(long lockWord) {
        return (int)(lockWord >> WAIT_WORD_SHIFT);
    }

    private static long lockWord(int countWord, int waitWord) {
        return ((long)countWord & 0xFFFFFFFFL) << COUNT_WORD_SHIFT | ((long)waitWord & 0xFFFFFFFFL) << WAIT_WORD_SHIFT;
    }

    private static <T> int getCountWord(Access<T> access, T t, long offset) {
        return access.readVolatileInt(t, offset + 0L);
    }

    private static <T> boolean casCountWord(Access<T> access, T t, long offset, int expected, int x) {
        return access.compareAndSwapInt(t, offset + 0L, expected, x);
    }

    private static <T> void putCountWord(Access<T> access, T t, long offset, int countWord) {
        access.writeOrderedInt(t, offset + 0L, countWord);
    }

    private static boolean writeLocked(int countWord) {
        return countWord == Integer.MIN_VALUE;
    }

    private static boolean updateLocked(int countWord) {
        return (countWord & 0x40000000) != 0;
    }

    private static void checkUpdateLocked(int countWord) {
        if (!VanillaReadWriteUpdateWithWaitsLockingStrategy.updateLocked(countWord)) {
            throw new IllegalMonitorStateException("Expected update lock");
        }
    }

    private static int readCount(int countWord) {
        return countWord & 0x3FFFFFFF;
    }

    private static void checkReadLocked(int countWord) {
        if (VanillaReadWriteUpdateWithWaitsLockingStrategy.readCount(countWord) <= 0) {
            throw new IllegalMonitorStateException("Expected read lock");
        }
    }

    private static void checkReadCountForIncrement(int countWord) {
        if (VanillaReadWriteUpdateWithWaitsLockingStrategy.readCount(countWord) == 0x3FFFFFFF) {
            throw new IllegalMonitorStateException("Lock count reached the limit of 1073741823");
        }
    }

    private static <T> int getWaitWord(Access<T> access, T t, long offset) {
        return access.readVolatileInt(t, offset + 4L);
    }

    private static <T> boolean casWaitWord(Access<T> access, T t, long offset, int expected, int x) {
        return access.compareAndSwapInt(t, offset + 4L, expected, x);
    }

    private static void checkWaitWordForIncrement(int waitWord) {
        if (waitWord == Integer.MAX_VALUE) {
            throw new IllegalMonitorStateException("Wait count reached the limit of 2147483647");
        }
    }

    private static void checkWaitWordForDecrement(int waitWord) {
        if (waitWord == 0) {
            throw new IllegalMonitorStateException("Wait count underflowed");
        }
    }

    private static <T> boolean tryWriteLockAndDeregisterWait0(Access<T> access, T t, long offset, long lockWord) {
        int waitWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.waitWord(lockWord);
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkWaitWordForDecrement(waitWord);
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.casLockWord(access, t, offset, lockWord, VanillaReadWriteUpdateWithWaitsLockingStrategy.lockWord(Integer.MIN_VALUE, waitWord - 1));
    }

    private static boolean checkExclusiveUpdateLocked(int countWord) {
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkUpdateLocked(countWord);
        return countWord == 0x40000000;
    }

    private static <T> void checkWriteLockedAndPut(Access<T> access, T t, long offset, int countWord) {
        if (!VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, Integer.MIN_VALUE, countWord)) {
            throw new IllegalMonitorStateException("Expected write lock");
        }
    }

    @Override
    public long resetState() {
        return 0L;
    }

    @Override
    public <T> void reset(Access<T> access, T t, long offset) {
        access.writeOrderedLong(t, offset, 0L);
    }

    @Override
    public <T> void resetKeepingWaits(Access<T> access, T t, long offset) {
        VanillaReadWriteUpdateWithWaitsLockingStrategy.putCountWord(access, t, offset, 0);
    }

    @Override
    public <T> boolean tryReadLock(Access<T> access, T t, long offset) {
        long lockWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getLockWord(access, t, offset);
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(lockWord);
        if (!VanillaReadWriteUpdateWithWaitsLockingStrategy.writeLocked(countWord) && VanillaReadWriteUpdateWithWaitsLockingStrategy.waitWord(lockWord) == 0) {
            VanillaReadWriteUpdateWithWaitsLockingStrategy.checkReadCountForIncrement(countWord);
            return VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, countWord, countWord + 1);
        }
        return false;
    }

    @Override
    public <T> boolean tryUpgradeReadToUpdateLock(Access<T> access, T t, long offset) {
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getCountWord(access, t, offset);
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkReadLocked(countWord);
        return !VanillaReadWriteUpdateWithWaitsLockingStrategy.updateLocked(countWord) && VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, countWord, countWord - 1 + 0x40000000);
    }

    @Override
    public <T> boolean tryUpgradeReadToWriteLock(Access<T> access, T t, long offset) {
        if (VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, 1, Integer.MIN_VALUE)) {
            return true;
        }
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getCountWord(access, t, offset);
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkReadLocked(countWord);
        return false;
    }

    @Override
    public <T> boolean tryUpgradeReadToWriteLockAndDeregisterWait(Access<T> access, T t, long offset) {
        long lockWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getLockWord(access, t, offset);
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(lockWord);
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkReadLocked(countWord);
        return countWord == 1 && VanillaReadWriteUpdateWithWaitsLockingStrategy.tryWriteLockAndDeregisterWait0(access, t, offset, lockWord);
    }

    @Override
    public <T> boolean tryUpdateLock(Access<T> access, T t, long offset) {
        long lockWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getLockWord(access, t, offset);
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(lockWord);
        if (!VanillaReadWriteUpdateWithWaitsLockingStrategy.updateLocked(countWord) && !VanillaReadWriteUpdateWithWaitsLockingStrategy.writeLocked(countWord) && VanillaReadWriteUpdateWithWaitsLockingStrategy.waitWord(lockWord) == 0) {
            return VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, countWord, countWord + 0x40000000);
        }
        return false;
    }

    @Override
    public <T> boolean tryWriteLock(Access<T> access, T t, long offset) {
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, 0, Integer.MIN_VALUE);
    }

    @Override
    public <T> boolean tryWriteLockAndDeregisterWait(Access<T> access, T t, long offset) {
        long lockWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getLockWord(access, t, offset);
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(lockWord);
        return countWord == 0 && VanillaReadWriteUpdateWithWaitsLockingStrategy.tryWriteLockAndDeregisterWait0(access, t, offset, lockWord);
    }

    @Override
    public <T> void registerWait(Access<T> access, T t, long offset) {
        int waitWord;
        do {
            waitWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getWaitWord(access, t, offset);
            VanillaReadWriteUpdateWithWaitsLockingStrategy.checkWaitWordForIncrement(waitWord);
        } while (!VanillaReadWriteUpdateWithWaitsLockingStrategy.casWaitWord(access, t, offset, waitWord, waitWord + 1));
    }

    @Override
    public <T> void deregisterWait(Access<T> access, T t, long offset) {
        int waitWord;
        do {
            waitWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getWaitWord(access, t, offset);
            VanillaReadWriteUpdateWithWaitsLockingStrategy.checkWaitWordForDecrement(waitWord);
        } while (!VanillaReadWriteUpdateWithWaitsLockingStrategy.casWaitWord(access, t, offset, waitWord, waitWord - 1));
    }

    @Override
    public <T> boolean tryUpgradeUpdateToWriteLock(Access<T> access, T t, long offset) {
        if (VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, 0x40000000, Integer.MIN_VALUE)) {
            return true;
        }
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getCountWord(access, t, offset);
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkUpdateLocked(countWord);
        return false;
    }

    @Override
    public <T> boolean tryUpgradeUpdateToWriteLockAndDeregisterWait(Access<T> access, T t, long offset) {
        long lockWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getLockWord(access, t, offset);
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(lockWord);
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.checkExclusiveUpdateLocked(countWord) && VanillaReadWriteUpdateWithWaitsLockingStrategy.tryWriteLockAndDeregisterWait0(access, t, offset, lockWord);
    }

    @Override
    public <T> void readUnlock(Access<T> access, T t, long offset) {
        int countWord;
        do {
            countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getCountWord(access, t, offset);
            VanillaReadWriteUpdateWithWaitsLockingStrategy.checkReadLocked(countWord);
        } while (!VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, countWord, countWord - 1));
    }

    @Override
    public <T> void updateUnlock(Access<T> access, T t, long offset) {
        int countWord;
        do {
            countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getCountWord(access, t, offset);
            VanillaReadWriteUpdateWithWaitsLockingStrategy.checkUpdateLocked(countWord);
        } while (!VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, countWord, countWord - 0x40000000));
    }

    @Override
    public <T> void downgradeUpdateToReadLock(Access<T> access, T t, long offset) {
        int countWord;
        do {
            countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.getCountWord(access, t, offset);
            VanillaReadWriteUpdateWithWaitsLockingStrategy.checkUpdateLocked(countWord);
            VanillaReadWriteUpdateWithWaitsLockingStrategy.checkReadCountForIncrement(countWord);
        } while (!VanillaReadWriteUpdateWithWaitsLockingStrategy.casCountWord(access, t, offset, countWord, countWord - 0x40000000 + 1));
    }

    @Override
    public <T> void writeUnlock(Access<T> access, T t, long offset) {
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkWriteLockedAndPut(access, t, offset, 0);
    }

    @Override
    public <T> void downgradeWriteToUpdateLock(Access<T> access, T t, long offset) {
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkWriteLockedAndPut(access, t, offset, 0x40000000);
    }

    @Override
    public boolean isUpdateLocked(long state) {
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.updateLocked(VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(state));
    }

    @Override
    public <T> void downgradeWriteToReadLock(Access<T> access, T t, long offset) {
        VanillaReadWriteUpdateWithWaitsLockingStrategy.checkWriteLockedAndPut(access, t, offset, 1);
    }

    @Override
    public <T> long getState(ReadAccess<T> access, T t, long offset) {
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.getLockWord(access, t, offset);
    }

    @Override
    public int readLockCount(long state) {
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.readCount(VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(state));
    }

    @Override
    public boolean isWriteLocked(long state) {
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.writeLocked(VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(state));
    }

    @Override
    public int waitCount(long state) {
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.waitWord(state);
    }

    @Override
    public boolean isLocked(long state) {
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(state) != 0;
    }

    @Override
    public int lockCount(long state) {
        int countWord = VanillaReadWriteUpdateWithWaitsLockingStrategy.countWord(state);
        int lockCount = VanillaReadWriteUpdateWithWaitsLockingStrategy.readCount(countWord);
        if (lockCount > 0) {
            return lockCount + (VanillaReadWriteUpdateWithWaitsLockingStrategy.updateLocked(countWord) ? 1 : 0);
        }
        return VanillaReadWriteUpdateWithWaitsLockingStrategy.writeLocked(countWord) ? 1 : 0;
    }

    @Override
    public String toString(long state) {
        return "[read locks = " + this.readLockCount(state) + ", update locked = " + this.isUpdateLocked(state) + ", write locked = " + this.isWriteLocked(state) + ", waits = " + this.waitCount(state) + "]";
    }

    @Override
    public int sizeInBytes() {
        return 8;
    }
}

