/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.locks;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.locks.AcquisitionStrategy;
import net.openhft.chronicle.algo.locks.LockingStrategy;
import net.openhft.chronicle.algo.locks.ReadWriteWithWaitsLockingStrategy;
import net.openhft.chronicle.algo.locks.TryAcquireOperation;

public final class AcquisitionStrategies {
    private AcquisitionStrategies() {
    }

    public static AcquisitionStrategy<LockingStrategy, RuntimeException> spinLoop(long duration, TimeUnit unit) {
        return new SpinLoopAcquisitionStrategy<LockingStrategy>(duration, unit);
    }

    public static AcquisitionStrategy<LockingStrategy, RuntimeException> spinLoopOrFail(long duration, TimeUnit unit) {
        return new SpinLoopOrFailAcquisitionStrategy<LockingStrategy>(duration, unit);
    }

    public static AcquisitionStrategy<ReadWriteWithWaitsLockingStrategy, RuntimeException> spinLoopRegisteringWaitOrFail(long duration, TimeUnit unit) {
        return new SpinLoopWriteWithWaitsAcquisitionStrategy(duration, unit);
    }

    private static class SpinLoopWriteWithWaitsAcquisitionStrategy
    extends SpinLoopOrFailAcquisitionStrategy<ReadWriteWithWaitsLockingStrategy> {
        private SpinLoopWriteWithWaitsAcquisitionStrategy(long duration, TimeUnit unit) {
            super(duration, unit);
        }

        @Override
        <T> void beforeLoop(ReadWriteWithWaitsLockingStrategy strategy, Access<T> access, T t, long offset) {
            strategy.registerWait(access, t, offset);
        }

        @Override
        <T> void afterLoop(ReadWriteWithWaitsLockingStrategy strategy, Access<T> access, T t, long offset) {
            strategy.deregisterWait(access, t, offset);
        }
    }

    private static class SpinLoopOrFailAcquisitionStrategy<S extends LockingStrategy>
    extends SpinLoopAcquisitionStrategy<S> {
        private SpinLoopOrFailAcquisitionStrategy(long duration, TimeUnit unit) {
            super(duration, unit);
        }

        @Override
        boolean end() {
            throw new IllegalStateException("Failed to acquire the lock");
        }
    }

    private static class SpinLoopAcquisitionStrategy<S extends LockingStrategy>
    implements AcquisitionStrategy<S, RuntimeException> {
        private final long durationNanos;

        private SpinLoopAcquisitionStrategy(long duration, TimeUnit unit) {
            this.durationNanos = unit.toNanos(duration);
        }

        @Override
        public <T> boolean acquire(TryAcquireOperation<? super S> operation, S strategy, Access<T> access, T t, long offset) {
            if (operation.tryAcquire(strategy, access, t, offset)) {
                return true;
            }
            long deadLine = System.currentTimeMillis() + this.durationNanos;
            this.beforeLoop(strategy, access, t, offset);
            do {
                if (!operation.tryAcquire(strategy, access, t, offset)) continue;
                return true;
            } while (deadLine - System.currentTimeMillis() >= 0L);
            this.afterLoop(strategy, access, t, offset);
            return this.end();
        }

        <T> void beforeLoop(S strategy, Access<T> access, T t, long offset) {
        }

        <T> void afterLoop(S strategy, Access<T> access, T t, long offset) {
        }

        boolean end() {
            return false;
        }
    }
}

