/*
 * Decompiled with CFR 0.152.
 */
package software.chronicle;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="enforcer", defaultPhase=LifecyclePhase.VERIFY)
public class BinaryCompatibilityEnforcerPluginMogo
extends AbstractMojo {
    public static final String REPORT = "Report: ";
    public static final String BINARY_COMPATIBILITY = "Binary compatibility: ";
    public static final String BAR = "\n------------------------------------------------------------------------\n";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="japi-compliance-checker.pl -lib NAME %s %s", readonly=true, required=false)
    private String expression;
    @Parameter(defaultValue="", required=false)
    private String referenceVersion;
    @Parameter(defaultValue="100.0", required=false)
    double binaryCompatibilityPercentageRequired;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("%s\nBINARY COMPATIBILITY ENFORCER\n%s", BAR, BAR));
        this.getLog().info((CharSequence)"Starting...");
        try {
            this.checkJavaAPIComplianceCheckerInstalled();
        }
        catch (MojoExecutionException e) {
            this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            return;
        }
        Build build = this.project.getBuild();
        if (build == null) {
            throw new MojoExecutionException("build not found");
        }
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String outputDirectory = build.getOutputDirectory();
        this.getLog().info((CharSequence)this.referenceVersion);
        String pathToJar1 = null;
        if (this.referenceVersion == null || this.referenceVersion.isEmpty()) {
            String version = this.project.getVersion();
            int i = version.indexOf(".");
            if (i != -1) {
                if ((i = version.indexOf(".", i + 1)) != -1) {
                    version = version.substring(0, i);
                    this.referenceVersion = version + ".0";
                    this.getLog().info((CharSequence)("setting referenceVersion=" + this.referenceVersion));
                    try {
                        pathToJar1 = this.downloadArtifact(groupId, artifactId, this.referenceVersion, outputDirectory).getAbsolutePath();
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Please set <referenceVersion> config, can not download default version=" + this.referenceVersion + " of " + artifactId, e);
                    }
                }
                if (pathToJar1 == null) {
                    throw new MojoExecutionException("Please set <referenceVersion> config");
                }
            } else {
                pathToJar1 = this.downloadArtifact(groupId, artifactId, this.referenceVersion, outputDirectory).getAbsolutePath();
            }
        } else {
            pathToJar1 = this.downloadArtifact(groupId, artifactId, this.referenceVersion, outputDirectory).getAbsolutePath();
        }
        this.getLog().debug((CharSequence)("pathToJar1=" + pathToJar1));
        String directory = build.getDirectory();
        String finalName = this.project.getBuild().getFinalName();
        String pathToJar2 = String.format("%s%s%s.jar", directory, File.separator, finalName);
        this.getLog().debug((CharSequence)("pathToJar2=" + pathToJar2));
        if (finalName.endsWith("0-SNAPSHOT.jar") || finalName.endsWith("0.jar")) {
            return;
        }
        this.checkBinaryCompatibility(pathToJar1, pathToJar2);
    }

    private File downloadArtifact(String group, String artifactId, String version, String target) throws MojoExecutionException {
        File tempFile = new File(target, artifactId + "-" + version + ".jar");
        tempFile.delete();
        String command = String.format("mvn dependency:get -Dartifact=%s:%s:%s:jar -Dtransitive=false -Ddest=%s -DremoteRepositories=chronicle-enterprise-release::::https://nexus.chronicle.software/content/repositories/releases ", group, artifactId, version, tempFile);
        this.getLog().info((CharSequence)command);
        BufferedReader stdError = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            stdInput.readLine();
            while (true) {
                String s1;
                if ((s1 = stdInput.readLine()) == null) {
                    this.dumpErrorToConsole(stdError);
                    throw new MojoExecutionException("unable to download using command=" + command);
                }
                if (s1.contains("BUILD SUCCESS")) break;
                this.getLog().debug((CharSequence)s1);
            }
            File file = tempFile;
            return file;
        }
        catch (Exception e) {
            this.dumpErrorToConsole(stdError);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            this.shutdown(p);
        }
    }

    public void checkBinaryCompatibility(String jar1, String jar2) throws MojoExecutionException {
        BufferedReader stdError = null;
        Process p = null;
        try {
            String s1;
            String command = String.format(this.expression, jar1, jar2);
            this.getLog().debug((CharSequence)("command=" + command));
            p = new ProcessBuilder("/bin/sh", "-c", command).start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String binaryCompatibility = "";
            while (true) {
                if ((s1 = stdInput.readLine()) == null) {
                    this.dumpErrorToConsole(stdError);
                    throw new MojoExecutionException("failed to to successfully execute, command=" + command);
                }
                if (s1.startsWith(BINARY_COMPATIBILITY)) {
                    assert (s1.endsWith("%"));
                    binaryCompatibility = s1.substring(BINARY_COMPATIBILITY.length(), s1.length() - 1);
                }
                if (s1.startsWith(REPORT)) break;
                this.getLog().debug((CharSequence)s1);
            }
            String report = s1.substring(REPORT.length());
            if (Double.parseDouble(binaryCompatibility) < this.binaryCompatibilityPercentageRequired) {
                throw new MojoExecutionException("\n\n------------------------------------------------------------------------\nBINARY COMPATIBILITY ENFORCER - FAILURE: " + binaryCompatibility + "%  binary compatibility\nYour changes are only " + binaryCompatibility + "% binary compatibility, this enforcer plugin requires at least " + this.binaryCompatibilityPercentageRequired + "% binary compatibility,\n between " + jar1 + " and " + jar2 + "\nsee report \"file://" + new File(report).getAbsolutePath() + "\"" + BAR);
            }
            this.getLog().info((CharSequence)String.format("Whilst checking against %s", jar1));
            this.getLog().info((CharSequence)String.format("%sBINARY COMPATIBILITY ENFORCER - SUCCESSFUL%s", BAR, BAR));
            this.shutdown(p);
            return;
        }
        catch (IOException e) {
            try {
                this.dumpErrorToConsole(stdError);
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                this.shutdown(p);
                throw throwable;
            }
        }
    }

    private void dumpErrorToConsole(BufferedReader std) throws MojoExecutionException {
        if (std == null) {
            return;
        }
        try {
            String s1 = std.readLine();
            while (s1 != null) {
                this.getLog().warn((CharSequence)s1);
                s1 = std.readLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public void checkJavaAPIComplianceCheckerInstalled() throws MojoExecutionException {
        Process p = null;
        BufferedReader stdError = null;
        try {
            p = new ProcessBuilder("/bin/sh", "-c", "japi-compliance-checker.pl -l").start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            stdInput.readLine();
            String firstLine = stdInput.readLine();
            if (!firstLine.startsWith("Java API Compliance Checker")) {
                throw new MojoExecutionException("Unable to load Java API Compliance Checker, please add it your $PATH and check it permissions.");
            }
            this.getLog().info((CharSequence)"Java API Compliance Checker - correctly installed");
            this.shutdown(p);
        }
        catch (IOException | MojoExecutionException e) {
            try {
                this.dumpErrorToConsole(stdError);
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                this.shutdown(p);
                throw throwable;
            }
        }
    }

    private void shutdown(Process p) {
        if (p != null) {
            p.destroy();
            try {
                p.waitFor(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                p.destroyForcibly();
            }
        }
    }
}

