/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public final class Utilities {
    public static final boolean ISLINUX = "Linux".equals(System.getProperty("os.name"));
    static final boolean IS64BIT = Utilities.is64Bit0();

    private Utilities() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static String toHexString(BitSet set) {
        long[] longs;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out);
        for (long aLong : longs = set.toLongArray()) {
            writer.write(Long.toHexString(aLong));
        }
        writer.flush();
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String toBinaryString(BitSet set) {
        long[] longs;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out);
        for (long aLong : longs = set.toLongArray()) {
            writer.write(Long.toBinaryString(aLong));
        }
        writer.flush();
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int currentProcessId() {
        try {
            Class<?> phClass = Class.forName("java.lang.ProcessHandle");
            Object current = phClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            long pid = (Long)phClass.getMethod("pid", new Class[0]).invoke(current, new Object[0]);
            return (int)pid;
        }
        catch (Throwable phClass) {
            try {
                String name = ManagementFactory.getRuntimeMXBean().getName();
                return Integer.parseInt(name.split("@")[0]);
            }
            catch (Throwable e) {
                return -1;
            }
        }
    }
}

