/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityStrategies;
import net.openhft.affinity.AffinityStrategy;
import net.openhft.affinity.CpuLayout;
import net.openhft.affinity.LockCheck;
import net.openhft.affinity.LockInventory;
import net.openhft.affinity.impl.NoCpuLayout;
import net.openhft.affinity.impl.VanillaCpuLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityLock
implements Closeable {
    public static final String AFFINITY_RESERVED = "affinity.reserved";
    public static final int PROCESSORS;
    public static final BitSet BASE_AFFINITY;
    public static final BitSet RESERVED_AFFINITY;
    static final int ANY_CPU = -1;
    private static final Logger LOGGER;
    private static final LockInventory LOCK_INVENTORY;
    private final int cpuId;
    private final int cpuId2;
    private final boolean base;
    private final boolean reservable;
    private final LockInventory lockInventory;
    boolean bound = false;
    @Nullable
    Thread assignedThread;
    Throwable boundHere;
    private boolean resetAffinity = true;

    AffinityLock(int cpuId, int cpuId2, boolean base, boolean reservable, LockInventory lockInventory) {
        this.lockInventory = lockInventory;
        this.cpuId = cpuId;
        this.cpuId2 = cpuId2;
        this.base = base;
        this.reservable = reservable;
    }

    public static void cpuLayout(@NotNull CpuLayout cpuLayout) {
        LOCK_INVENTORY.set(cpuLayout);
    }

    @NotNull
    public static CpuLayout cpuLayout() {
        return LOCK_INVENTORY.getCpuLayout();
    }

    private static BitSet getReservedAffinity0() {
        String reservedAffinity = System.getProperty(AFFINITY_RESERVED);
        if (BASE_AFFINITY != null && (reservedAffinity == null || reservedAffinity.trim().isEmpty())) {
            BitSet reserverable = new BitSet(PROCESSORS);
            reserverable.set(1, PROCESSORS, true);
            reserverable.andNot(BASE_AFFINITY);
            if (reserverable.isEmpty() && PROCESSORS > 1) {
                reserverable.set(1, PROCESSORS);
                return reserverable;
            }
            return reserverable;
        }
        reservedAffinity = reservedAffinity.trim();
        long[] longs = new long[1 + (reservedAffinity.length() - 1) / 16];
        int end = reservedAffinity.length();
        for (int i = 0; i < longs.length; ++i) {
            int begin = Math.max(0, end - 16);
            longs[i] = Long.parseUnsignedLong(reservedAffinity.substring(begin, end), 16);
            end = begin;
        }
        return BitSet.valueOf(longs);
    }

    public static AffinityLock acquireLock() {
        return AffinityLock.acquireLock(true);
    }

    public static AffinityLock acquireCore() {
        return AffinityLock.acquireCore(true);
    }

    public static AffinityLock acquireLock(boolean bind) {
        return AffinityLock.acquireLock(bind, -1, AffinityStrategies.ANY);
    }

    public static AffinityLock acquireLock(int cpuId) {
        if (AffinityLock.isInvalidCpuId(cpuId)) {
            return LOCK_INVENTORY.noLock();
        }
        return AffinityLock.acquireLock(true, cpuId, AffinityStrategies.ANY);
    }

    private static boolean isInvalidCpuId(int cpuId) {
        if (cpuId < 0 || cpuId >= PROCESSORS) {
            LOGGER.warn("cpuId must be between 0 and {}: {}", (Object)(PROCESSORS - 1), (Object)cpuId);
            return true;
        }
        return false;
    }

    public static AffinityLock acquireLock(int[] cpus) {
        for (int cpu : cpus) {
            AffinityLock lock;
            if (AffinityLock.isInvalidCpuId(cpu) || (lock = AffinityLock.tryAcquireLock(true, cpu)) == null) continue;
            LOGGER.info("Acquired lock on CPU {}", (Object)cpu);
            return lock;
        }
        LOGGER.warn("Failed to lock any CPU in explicit list {}", (Object)Arrays.toString(cpus));
        return LOCK_INVENTORY.noLock();
    }

    public static AffinityLock acquireLockLastMinus(int n) {
        return AffinityLock.acquireLock(true, PROCESSORS - n, AffinityStrategies.ANY);
    }

    public static AffinityLock acquireLock(String desc) {
        int cpuId;
        if (desc == null) {
            return LOCK_INVENTORY.noLock();
        }
        if ((desc = desc.toLowerCase()).startsWith("last")) {
            int lastN;
            String last = desc.substring(4);
            if (last.isEmpty()) {
                lastN = 0;
            } else {
                try {
                    lastN = Integer.parseInt(last);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot parse '" + desc + "'", e);
                }
            }
            if (lastN > 0) {
                throw new IllegalArgumentException("Cannot parse '" + desc + "'");
            }
            cpuId = PROCESSORS + lastN - 1;
        } else {
            if (desc.startsWith("csv:")) {
                String content = desc.substring(4);
                int[] cpus = Arrays.stream(content.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
                return AffinityLock.acquireLock(cpus);
            }
            if (desc.equals("none")) {
                return LOCK_INVENTORY.noLock();
            }
            if (desc.equals("any")) {
                return AffinityLock.acquireLock();
            }
            try {
                cpuId = Integer.parseInt(desc);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse '" + desc + "'", e);
            }
        }
        if (cpuId <= 0) {
            LOGGER.warn("Cannot allocate 0 or negative cpuIds '{}'", (Object)desc);
            return LOCK_INVENTORY.noLock();
        }
        return AffinityLock.acquireLock(cpuId);
    }

    public static AffinityLock acquireCore(boolean bind) {
        return AffinityLock.acquireCore(bind, -1, AffinityStrategies.ANY);
    }

    private static AffinityLock acquireLock(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        Warnings.warmNoReservedCPUs();
        return LOCK_INVENTORY.acquireLock(bind, cpuId, strategies);
    }

    private static AffinityLock tryAcquireLock(boolean bind, int cpuId) {
        return LOCK_INVENTORY.tryAcquireLock(bind, cpuId);
    }

    private static AffinityLock acquireCore(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        Warnings.warmNoReservedCPUs();
        return LOCK_INVENTORY.acquireCore(bind, cpuId, strategies);
    }

    @NotNull
    public static String dumpLocks() {
        return LOCK_INVENTORY.dumpLocks();
    }

    private static boolean areAssertionsEnabled() {
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return debug;
    }

    public boolean resetAffinity() {
        return this.resetAffinity;
    }

    public AffinityLock resetAffinity(boolean resetAffinity) {
        this.resetAffinity = resetAffinity;
        return this;
    }

    final void assignCurrentThread(boolean bind, boolean wholeCore) {
        this.assignedThread = Thread.currentThread();
        if (bind) {
            this.bind(wholeCore);
        }
    }

    public void bind() {
        this.bind(false);
    }

    public void bind(boolean wholeCore) {
        if (this.bound && this.assignedThread != null && this.assignedThread.isAlive()) {
            throw new IllegalStateException("cpu " + this.cpuId + " already bound to " + this.assignedThread);
        }
        if (AffinityLock.areAssertionsEnabled()) {
            this.boundHere = new Throwable("Bound here");
        }
        if (wholeCore) {
            this.lockInventory.bindWholeCore(this.cpuId);
        } else if (this.cpuId >= 0) {
            this.bound = true;
            this.assignedThread = Thread.currentThread();
            LOGGER.info("Assigning cpu {} to {} on thread id {}", new Object[]{this.cpuId, this.assignedThread, Affinity.getThreadId()});
        }
        if (this.cpuId >= 0) {
            BitSet affinity = new BitSet();
            affinity.set(this.cpuId, true);
            Affinity.setAffinity(affinity);
        }
    }

    final boolean canReserve(boolean specified) {
        if (!specified && !this.reservable) {
            return false;
        }
        if (!LockCheck.isCpuFree(this.cpuId)) {
            return false;
        }
        if (this.assignedThread != null) {
            if (this.assignedThread.isAlive()) {
                return false;
            }
            LOGGER.warn("Lock assigned to {} but this thread is dead.", (Object)this.assignedThread);
        }
        return true;
    }

    public AffinityLock acquireLock(AffinityStrategy ... strategies) {
        return AffinityLock.acquireLock(false, this.cpuId, strategies);
    }

    public void release() {
        if (this.cpuId == -1) {
            return;
        }
        boolean resetAffinity = this.resetAffinity;
        this.resetAffinity = true;
        this.lockInventory.release(resetAffinity);
    }

    @Override
    public void close() {
        this.release();
    }

    protected void finalize() throws Throwable {
        if (this.bound) {
            LOGGER.warn("Affinity lock for {} was discarded rather than release()d in a controlled manner.", (Object)this.assignedThread, (Object)this.boundHere);
            this.release();
        }
        super.finalize();
    }

    public int cpuId() {
        return this.cpuId;
    }

    public int cpuId2() {
        return this.cpuId2;
    }

    public boolean isAllocated() {
        return this.cpuId >= 0;
    }

    public boolean isBound() {
        return this.bound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.assignedThread != null) {
            sb.append(this.assignedThread).append(" alive=").append(this.assignedThread.isAlive());
        } else if (this.reservable) {
            sb.append("Reserved for this application");
        } else if (this.base) {
            sb.append("General use CPU");
        } else {
            sb.append("CPU not available");
        }
        return sb.toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(AffinityLock.class);
        int processors = Runtime.getRuntime().availableProcessors();
        VanillaCpuLayout cpuLayout = null;
        try {
            if (new File("/proc/cpuinfo").exists()) {
                cpuLayout = VanillaCpuLayout.fromCpuInfo();
                processors = cpuLayout.cpus();
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to load /proc/cpuinfo", e);
        }
        PROCESSORS = processors;
        BASE_AFFINITY = Affinity.getAffinity();
        RESERVED_AFFINITY = AffinityLock.getReservedAffinity0();
        LOCK_INVENTORY = new LockInventory(cpuLayout == null ? new NoCpuLayout(PROCESSORS) : cpuLayout);
    }

    static class Warnings {
        Warnings() {
        }

        static void warmNoReservedCPUs() {
            if (RESERVED_AFFINITY.isEmpty() && PROCESSORS > 1) {
                LoggerFactory.getLogger(AffinityLock.class).info("No isolated CPUs found, so assuming CPUs 1 to {} available.", (Object)(PROCESSORS - 1));
            }
        }
    }
}

