/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import net.openhft.affinity.IAffinity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PosixJNAAffinity
extends Enum<PosixJNAAffinity>
implements IAffinity {
    public static final /* enum */ PosixJNAAffinity INSTANCE;
    public static final boolean LOADED;
    private static final Logger LOGGER;
    private static final String LIBRARY_NAME;
    private static final int PROCESS_ID;
    private final ThreadLocal<Integer> THREAD_ID = new ThreadLocal();
    private static final boolean ISLINUX;
    private static final boolean IS64BIT;
    private static final int SYS_gettid;
    private static final Object[] NO_ARGS;
    private static final /* synthetic */ PosixJNAAffinity[] $VALUES;

    public static PosixJNAAffinity[] values() {
        return (PosixJNAAffinity[])$VALUES.clone();
    }

    public static PosixJNAAffinity valueOf(String name) {
        return Enum.valueOf(PosixJNAAffinity.class, name);
    }

    @Override
    public long getAffinity() {
        CLibrary lib = CLibrary.INSTANCE;
        LongByReference cpuset = new LongByReference(0L);
        try {
            int ret = lib.sched_getaffinity(0, 8, (PointerType)cpuset);
            if (ret < 0) {
                throw new IllegalStateException("sched_getaffinity((8) , &(" + cpuset + ") ) return " + ret);
            }
            return cpuset.getValue();
        }
        catch (LastErrorException e) {
            if (e.getErrorCode() != 22) {
                throw new IllegalStateException("sched_getaffinity((8) , &(" + cpuset + ") ) errorNo=" + e.getErrorCode(), e);
            }
            IntByReference cpuset32 = new IntByReference(0);
            try {
                int ret = lib.sched_getaffinity(0, 4, (PointerType)cpuset32);
                if (ret < 0) {
                    throw new IllegalStateException("sched_getaffinity((4) , &(" + cpuset32 + ") ) return " + ret);
                }
                return (long)cpuset32.getValue() & 0xFFFFFFFFL;
            }
            catch (LastErrorException e2) {
                throw new IllegalStateException("sched_getaffinity((4) , &(" + cpuset32 + ") ) errorNo=" + e2.getErrorCode(), e2);
            }
        }
    }

    @Override
    public void setAffinity(long affinity) {
        CLibrary lib;
        int procs;
        block8: {
            procs = Runtime.getRuntime().availableProcessors();
            if (procs < 64 && (affinity & (1L << procs) - 1L) == 0L) {
                throw new IllegalArgumentException("Cannot set zero affinity");
            }
            lib = CLibrary.INSTANCE;
            try {
                int ret = lib.sched_setaffinity(0, 8, (PointerType)new LongByReference(affinity));
                if (ret < 0) {
                    throw new IllegalStateException("sched_setaffinity((8) , &(" + affinity + ") ) return " + ret);
                }
            }
            catch (LastErrorException e) {
                if (e.getErrorCode() == 22 && (affinity & 0xFFFFFFFFL) == affinity) break block8;
                throw new IllegalStateException("sched_setaffinity((8) , &(" + affinity + ") ) errorNo=" + e.getErrorCode(), e);
            }
        }
        if (procs < 32 && (affinity & (1L << procs) - 1L) == 0L) {
            throw new IllegalArgumentException("Cannot set zero affinity for 32-bit set affinity");
        }
        IntByReference cpuset32 = new IntByReference(0);
        cpuset32.setValue((int)affinity);
        try {
            int ret = lib.sched_setaffinity(0, 4, (PointerType)cpuset32);
            if (ret < 0) {
                throw new IllegalStateException("sched_setaffinity((4) , &(" + Integer.toHexString(cpuset32.getValue()) + ") ) return " + ret);
            }
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_setaffinity((4) , &(" + Integer.toHexString(cpuset32.getValue()) + ") ) errorNo=" + e.getErrorCode(), e);
        }
    }

    @Override
    public int getCpu() {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            int ret = lib.sched_getcpu();
            if (ret < 0) {
                throw new IllegalStateException("sched_getcpu( ) return " + ret);
            }
            return ret;
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getcpu( ) errorNo=" + e.getErrorCode(), e);
        }
    }

    @Override
    public int getProcessId() {
        return PROCESS_ID;
    }

    @Override
    public int getThreadId() {
        if (ISLINUX) {
            Integer tid = this.THREAD_ID.get();
            if (tid == null) {
                tid = CLibrary.INSTANCE.syscall(SYS_gettid, NO_ARGS);
                this.THREAD_ID.set(tid);
            }
            return tid;
        }
        return -1;
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    static /* synthetic */ String access$000() {
        return LIBRARY_NAME;
    }

    static {
        int processId;
        INSTANCE = new PosixJNAAffinity();
        $VALUES = new PosixJNAAffinity[]{INSTANCE};
        LOGGER = LoggerFactory.getLogger(PosixJNAAffinity.class);
        LIBRARY_NAME = Platform.isWindows() ? "msvcrt" : "c";
        try {
            processId = CLibrary.INSTANCE.getpid();
        }
        catch (Exception ignored) {
            processId = -1;
        }
        PROCESS_ID = processId;
        ISLINUX = "Linux".equals(System.getProperty("os.name"));
        IS64BIT = PosixJNAAffinity.is64Bit0();
        SYS_gettid = PosixJNAAffinity.is64Bit() ? 186 : 224;
        NO_ARGS = new Object[0];
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Unable to load jna library {}", e);
        }
        LOADED = loaded;
    }

    static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)PosixJNAAffinity.access$000(), CLibrary.class);

        public int sched_setaffinity(int var1, int var2, PointerType var3) throws LastErrorException;

        public int sched_getaffinity(int var1, int var2, PointerType var3) throws LastErrorException;

        public int sched_getcpu() throws LastErrorException;

        public int getpid() throws LastErrorException;

        public int syscall(int var1, Object ... var2) throws LastErrorException;
    }
}

