/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.AffinityStrategy;
import net.openhft.affinity.AffinitySupport;
import net.openhft.affinity.CpuLayout;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockInventory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockInventory.class);
    private CpuLayout cpuLayout;
    private AffinityLock[] logicalCoreLocks;
    private final NavigableMap<Integer, AffinityLock[]> physicalCoreLocks = new TreeMap<Integer, AffinityLock[]>();

    public LockInventory(CpuLayout cpuLayout) {
        this.set(cpuLayout);
    }

    public final synchronized CpuLayout getCpuLayout() {
        return this.cpuLayout;
    }

    public final synchronized void set(CpuLayout cpuLayout) {
        if (cpuLayout.equals(this.cpuLayout)) {
            return;
        }
        this.reset(cpuLayout);
        for (int i = 0; i < cpuLayout.cpus(); ++i) {
            boolean base = (AffinityLock.BASE_AFFINITY >> i & 1L) != 0L;
            boolean reservable = (AffinityLock.RESERVED_AFFINITY >> i & 1L) != 0L;
            LOGGER.trace("cpu " + i + " base={} reservable= {}", i, base, reservable);
            AffinityLock lock = this.logicalCoreLocks[i] = this.newLock(i, base, reservable);
            int layoutId = lock.cpuId();
            int physicalCore = this.toPhysicalCore(layoutId);
            AffinityLock[] locks = (AffinityLock[])this.physicalCoreLocks.get(physicalCore);
            if (locks == null) {
                locks = new AffinityLock[cpuLayout.threadsPerCore()];
                this.physicalCoreLocks.put(physicalCore, locks);
            }
            locks[cpuLayout.threadId((int)layoutId)] = lock;
        }
    }

    public final synchronized AffinityLock acquireLock(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        for (AffinityStrategy strategy : strategies) {
            for (int i = this.logicalCoreLocks.length - 1; i > 0; --i) {
                AffinityLock al = this.logicalCoreLocks[i];
                if (!al.canReserve() || cpuId >= 0 && !strategy.matches(cpuId, al.cpuId())) continue;
                al.assignCurrentThread(bind, false);
                return al;
            }
        }
        LOGGER.warn("No reservable CPU for {}", (Object)Thread.currentThread());
        return this.newLock(-1, false, false);
    }

    public final synchronized AffinityLock acquireCore(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        for (AffinityStrategy strategy : strategies) {
            Iterator i$ = this.physicalCoreLocks.descendingMap().values().iterator();
            block1: while (i$.hasNext()) {
                AffinityLock[] als;
                for (AffinityLock al : als = (AffinityLock[])i$.next()) {
                    if (!al.canReserve() || !strategy.matches(cpuId, al.cpuId())) continue block1;
                }
                AffinityLock al = als[0];
                al.assignCurrentThread(bind, true);
                return al;
            }
        }
        LOGGER.warn("No reservable Core for {}", (Object)Thread.currentThread());
        return this.acquireLock(bind, cpuId, strategies);
    }

    public final synchronized void bindWholeCore(int logicalCoreID) {
        if (logicalCoreID < 0) {
            LOGGER.warn("Can't bind core since it was not possible to reserve it!");
            return;
        }
        int core = this.toPhysicalCore(logicalCoreID);
        for (AffinityLock al : (AffinityLock[])this.physicalCoreLocks.get(core)) {
            if (al.isBound() && al.assignedThread != null && al.assignedThread.isAlive()) {
                LOGGER.warn("cpu {} already bound to {}", (Object)al.cpuId(), (Object)al.assignedThread);
                continue;
            }
            al.bound = true;
            al.assignedThread = Thread.currentThread();
        }
        if (LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder().append("Assigning core ").append(core);
            String sep = ": cpus ";
            for (AffinityLock al : (AffinityLock[])this.physicalCoreLocks.get(core)) {
                sb.append(sep).append(al.cpuId());
                sep = ", ";
            }
            sb.append(" to ").append(Thread.currentThread());
            LOGGER.info(sb.toString());
        }
    }

    public final synchronized void release() {
        Thread t = Thread.currentThread();
        for (AffinityLock al : this.logicalCoreLocks) {
            Thread at = al.assignedThread;
            if (at == t) {
                LOGGER.info("Releasing cpu {} from {}", (Object)al.cpuId(), (Object)t);
                al.assignedThread = null;
                al.bound = false;
                continue;
            }
            if (at == null || at.isAlive()) continue;
            LOGGER.warn("Releasing cpu {} from {} as it is not alive.", (Object)al.cpuId(), (Object)t);
            al.assignedThread = null;
            al.bound = false;
        }
        AffinitySupport.setAffinity(AffinityLock.BASE_AFFINITY);
    }

    public final synchronized String dumpLocks() {
        return LockInventory.dumpLocks(this.logicalCoreLocks);
    }

    protected AffinityLock newLock(int cpuId, boolean base, boolean reservable) {
        return new AffinityLock(cpuId, base, reservable, this);
    }

    private void reset(CpuLayout cpuLayout) {
        this.cpuLayout = cpuLayout;
        this.logicalCoreLocks = new AffinityLock[cpuLayout.cpus()];
        this.physicalCoreLocks.clear();
    }

    private int toPhysicalCore(int layoutId) {
        return this.cpuLayout.socketId(layoutId) * this.cpuLayout.coresPerSocket() + this.cpuLayout.coreId(layoutId);
    }

    public static String dumpLocks(@NotNull AffinityLock[] locks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < locks.length; ++i) {
            AffinityLock al = locks[i];
            sb.append(i).append(": ");
            sb.append(al.toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

