/*
 * Decompiled with CFR 0.152.
 */
package org.openesb.runtime.tracking.util;

import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openesb.runtime.tracking.util.TransformerPool;
import org.w3c.dom.Node;

public class NormalizedMessageUtil {
    private static DocumentBuilder db = null;

    public static boolean hasInMessage(MessageExchange mex) {
        if (mex instanceof InOnly) {
            return ((InOnly)mex).getInMessage() != null;
        }
        if (mex instanceof InOut) {
            return ((InOut)mex).getInMessage() != null;
        }
        return false;
    }

    public static boolean hasOutMessage(MessageExchange mex) {
        if (mex instanceof InOut) {
            return ((InOut)mex).getOutMessage() != null;
        }
        return false;
    }

    public static boolean hasFaultMessage(MessageExchange mex) {
        return mex.getFault() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getInMessage(MessageExchange mex) throws TransformerConfigurationException {
        Source s = null;
        if (mex instanceof InOnly) {
            s = ((InOnly)mex).getInMessage().getContent();
        } else if (mex instanceof InOut) {
            s = ((InOut)mex).getInMessage().getContent();
        } else {
            return null;
        }
        Transformer t = null;
        try {
            t = TransformerPool.get().retrieve();
            DOMResult dr = new DOMResult();
            t.transform(s, dr);
            Node node = dr.getNode();
            return node;
        }
        catch (TransformerConfigurationException ex) {
            Node node = null;
            return node;
        }
        catch (TransformerException ex) {
            Node node = null;
            return node;
        }
        finally {
            if (t != null) {
                TransformerPool.get().relinquish(t);
            }
        }
    }

    public static Source getInMessageCopy(MessageExchange mex) throws TransformerConfigurationException {
        Node n = NormalizedMessageUtil.getInMessage(mex);
        if (n == null) {
            return null;
        }
        return new DOMSource(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getOutMessage(MessageExchange mex) throws TransformerConfigurationException {
        NormalizedMessage nm;
        Source s = null;
        if (mex instanceof InOut && (nm = ((InOut)mex).getOutMessage()) != null) {
            s = nm.getContent();
        }
        if (s == null) {
            return null;
        }
        Transformer t = null;
        try {
            t = TransformerPool.get().retrieve();
            DOMResult dr = new DOMResult();
            t.transform(s, dr);
            Node node = dr.getNode();
            return node;
        }
        catch (TransformerConfigurationException ex) {
            Node node = null;
            return node;
        }
        catch (TransformerException ex) {
            Node node = null;
            return node;
        }
        finally {
            if (t != null) {
                TransformerPool.get().relinquish(t);
            }
        }
    }

    public static Source getOutMessageCopy(MessageExchange mex) throws TransformerConfigurationException {
        Node n = NormalizedMessageUtil.getOutMessage(mex);
        if (n == null) {
            return null;
        }
        return new DOMSource(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getFaultMessage(MessageExchange mex) throws TransformerConfigurationException {
        Fault f;
        Source s = null;
        if (mex.getFault() != null && (f = mex.getFault()) != null) {
            s = f.getContent();
        }
        if (s == null) {
            return null;
        }
        Transformer t = null;
        try {
            t = TransformerPool.get().retrieve();
            DOMResult dr = new DOMResult();
            t.transform(s, dr);
            Node node = dr.getNode();
            return node;
        }
        catch (TransformerConfigurationException ex) {
            Node node = null;
            return node;
        }
        catch (TransformerException ex) {
            Node node = null;
            return node;
        }
        finally {
            if (t != null) {
                TransformerPool.get().relinquish(t);
            }
        }
    }

    public static Source getFaultMessageCopy(MessageExchange mex) throws TransformerConfigurationException {
        Node n = NormalizedMessageUtil.getFaultMessage(mex);
        if (n == null) {
            return null;
        }
        return new DOMSource(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Source messageContent) {
        Transformer t = null;
        try {
            t = TransformerPool.get().retrieve();
            StringWriter sw = new StringWriter();
            t.transform(messageContent, new StreamResult(sw));
            String string = sw.toString();
            return string;
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(NormalizedMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
            String string = null;
            return string;
        }
        catch (TransformerException ex) {
            Logger.getLogger(NormalizedMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
            String string = null;
            return string;
        }
        finally {
            if (t != null) {
                try {
                    TransformerPool.get().relinquish(t);
                }
                catch (TransformerConfigurationException ex) {
                    Logger.getLogger(NormalizedMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    static {
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(NormalizedMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

