/*
 * Decompiled with CFR 0.152.
 */
package org.openesb.runtime.tracking.tasks.sample;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.transform.Source;
import org.openesb.runtime.tracking.MessageTrackingInfo;
import org.openesb.runtime.tracking.tasks.MessageTrackingTaskRunnable;
import org.openesb.runtime.tracking.util.NormalizedMessageUtil;

public class SimpleFileTask
extends MessageTrackingTaskRunnable {
    private String filePath = this.filePath.concat("/logs/");
    private static final Lock wl = new ReentrantReadWriteLock().writeLock();
    private MessageTrackingInfo trackingInfo;

    public SimpleFileTask(MessageTrackingInfo trackingInfo) {
        this.trackingInfo = trackingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileWriter fw = null;
        try {
            Source faultMsg;
            wl.lock();
            fw = this.getFileWriter();
            fw.write("\n");
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss dd.MM.yyyy");
            fw.write(sdf.format(this.trackingInfo.getDate()));
            fw.write("\n");
            fw.write(this.trackingInfo.getComment());
            fw.write("\n");
            fw.write("In Message is:\n");
            fw.write(NormalizedMessageUtil.toString(this.trackingInfo.getInMessage()));
            Source outMsg = this.trackingInfo.getOutMessage();
            if (outMsg != null) {
                fw.write("\n");
                fw.write("Out Message is:\n");
                fw.write(NormalizedMessageUtil.toString(outMsg));
            }
            if ((faultMsg = this.trackingInfo.getFaultMessage()) != null) {
                fw.write("\n");
                fw.write("Fault Message is:\n");
                fw.write(NormalizedMessageUtil.toString(faultMsg));
            }
            ServiceEndpoint se = this.trackingInfo.getEndpoint();
            String epName = se.getServiceName().getNamespaceURI().concat(se.getServiceName().getLocalPart());
            epName.concat(se.getEndpointName());
            fw.write("\nEndpoint is:\n");
            fw.write(epName);
            fw.write("\n");
            fw.write("Status is: ");
            fw.write(this.trackingInfo.getStatus().toString());
            fw.write("\n");
        }
        catch (IOException ioe) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SimpleFileTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            wl.unlock();
        }
    }

    private FileWriter getFileWriter() throws IOException {
        String fileName = this.trackingInfo.getMessageTrackingId().concat(".log");
        File f = new File(this.filePath.concat(fileName));
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f, true);
        return fw;
    }

    @Override
    public void track() {
        this.run();
    }
}

