/*
 * Decompiled with CFR 0.152.
 */
package org.openesb.runtime.tracking;

import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import org.openesb.runtime.tracking.util.NormalizedMessageUtil;

public class MessageTrackingInfo {
    private String comment;
    private Date date;
    private MessageExchange me;
    private Source inMessage;
    private Source outMessage;
    private Source faultMessage;
    private ServiceEndpoint endpoint;
    private String source;
    private String dest;
    private ExchangeStatus status;

    public MessageTrackingInfo(MessageExchange exchange, String comment) {
        this.me = exchange;
        this.comment = comment;
        this.date = Calendar.getInstance().getTime();
        try {
            this.inMessage = NormalizedMessageUtil.getInMessageCopy(this.me);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(MessageTrackingInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.outMessage = NormalizedMessageUtil.getOutMessageCopy(this.me);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(MessageTrackingInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.faultMessage = NormalizedMessageUtil.getFaultMessageCopy(this.me);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(MessageTrackingInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.endpoint = this.me.getEndpoint();
        this.status = this.me.getStatus();
    }

    public String getComment() {
        return this.comment;
    }

    public Date getDate() {
        return this.date;
    }

    public Source getInMessage() {
        return this.inMessage;
    }

    public Source getOutMessage() {
        return this.outMessage;
    }

    public Source getFaultMessage() {
        return this.faultMessage;
    }

    public String getExchangeId() {
        return this.me.getExchangeId();
    }

    public String getMessageTrackingId() {
        String trId = (String)this.me.getProperty("MESSAGE_TRACKING_ID");
        return trId == null ? this.me.getExchangeId() : trId;
    }

    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getDestinationComponent() {
        return this.dest;
    }

    public void setDestinationComponent(String dest) {
        this.dest = dest;
    }

    public String getSourceComponent() {
        return this.source;
    }

    public void setSourceComponent(String source) {
        this.source = source;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }
}

