/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.util;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import net.neoremind.dynamicproxy.exception.ObjectProviderException;
import net.neoremind.dynamicproxy.util.ProxyUtil;

public abstract class JavassistUtil {
    public static final String DEFAULT_BASE_NAME = "JavassistUtilsGenerated";
    private static final AtomicInteger classNumber = new AtomicInteger(0);
    private static final ClassPool classPool = new ClassPool();
    private static final Set<ClassLoader> classLoaders = Sets.newHashSet();

    public static void addField(Class<?> fieldType, String fieldName, CtClass enclosingClass) throws CannotCompileException {
        enclosingClass.addField(new CtField(JavassistUtil.resolve(fieldType), fieldName, enclosingClass));
    }

    public static void addInterfaces(CtClass ctClass, Class<?>[] proxyClasses) {
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class<?> proxyInterface = proxyClasses[i];
            ctClass.addInterface(JavassistUtil.resolve(proxyInterface));
        }
    }

    public static CtClass createClass(Class<?> superclass) {
        return JavassistUtil.createClass(DEFAULT_BASE_NAME, superclass);
    }

    public static synchronized CtClass createClass(String baseName, Class<?> superclass) {
        return classPool.makeClass(baseName + "_" + classNumber.incrementAndGet(), JavassistUtil.resolve(superclass));
    }

    public static CtClass resolve(Class<?> clazz) {
        Set<ClassLoader> set = classLoaders;
        synchronized (set) {
            try {
                ClassLoader loader = clazz.getClassLoader();
                if (loader != null && !classLoaders.contains(loader)) {
                    classLoaders.add(loader);
                    classPool.appendClassPath((ClassPath)new LoaderClassPath(loader));
                }
                return classPool.get(ProxyUtil.getJavaClassName(clazz));
            }
            catch (NotFoundException e) {
                throw new ObjectProviderException("Unable to find class " + clazz.getName() + " in default Javassist class pool.", e);
            }
        }
    }

    public static CtClass[] resolve(Class<?>[] classes) {
        CtClass[] ctClasses = new CtClass[classes.length];
        for (int i = 0; i < ctClasses.length; ++i) {
            ctClasses[i] = JavassistUtil.resolve(classes[i]);
        }
        return ctClasses;
    }

    static {
        classPool.appendClassPath((ClassPath)new LoaderClassPath(ClassLoader.getSystemClassLoader()));
    }
}

