/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.template;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.neoremind.dynamicproxy.MethodSignature;
import net.neoremind.dynamicproxy.template.ClassGenerator;

public abstract class GeneratorTemplate
implements ClassGenerator {
    public static Method[] getImplementationMethods(Class<?>[] proxyClasses) {
        HashMap signatureMethodMap = Maps.newHashMap();
        HashSet finalizedSignatures = Sets.newHashSet();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class<?> proxyInterface = proxyClasses[i];
            Method[] methods = proxyInterface.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                MethodSignature signature = new MethodSignature(methods[j]);
                if (Modifier.isFinal(methods[j].getModifiers())) {
                    finalizedSignatures.add(signature);
                    continue;
                }
                if (signatureMethodMap.containsKey(signature)) continue;
                signatureMethodMap.put(signature, methods[j]);
            }
        }
        Collection resultingMethods = signatureMethodMap.values();
        for (MethodSignature signature : finalizedSignatures) {
            resultingMethods.remove(signatureMethodMap.get(signature));
        }
        return resultingMethods.toArray(new Method[resultingMethods.size()]);
    }
}

