/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.impl;

import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.neoremind.dynamicproxy.Interceptor;
import net.neoremind.dynamicproxy.ObjectInvoker;
import net.neoremind.dynamicproxy.ObjectProvider;
import net.neoremind.dynamicproxy.bytebuddy.DynamicDelegator;
import net.neoremind.dynamicproxy.bytebuddy.InstanceCreator;
import net.neoremind.dynamicproxy.bytebuddy.ObjectInvokerAccessor;
import net.neoremind.dynamicproxy.exception.ProxyCreatorException;
import net.neoremind.dynamicproxy.support.DelegatorInvoker;
import net.neoremind.dynamicproxy.support.InterceptorInvoker;
import net.neoremind.dynamicproxy.template.ClassCache;
import net.neoremind.dynamicproxy.template.GeneratorTemplate;
import net.neoremind.dynamicproxy.template.SubclassCreatorTemplate;

public class ByteBuddyCreator
extends SubclassCreatorTemplate {
    protected static final ClassCache PROXY_CLASS_CACHE = new ClassCache(new ProxyGenerator());

    @Override
    public boolean canProxy(Class<?> ... proxyClasses) {
        Preconditions.checkNotNull(proxyClasses, (Object)"Proxy class cannot be NULL");
        Preconditions.checkArgument((proxyClasses.length == 1 ? 1 : 0) != 0, (Object)"ByteBuddy only supports one proxy class currently, but note that proxy class can be a Class or Interfaces which extends multi-interfaces");
        return super.canProxy(proxyClasses);
    }

    @Override
    public <T> T createDelegatorProxy(ClassLoader classLoader, ObjectProvider<?> delegateProvider, Class<?> ... proxyClasses) {
        return this.createProxy(classLoader, new DelegatorInvoker(delegateProvider), proxyClasses);
    }

    @Override
    public <T> T createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class<?> ... proxyClasses) {
        return this.createProxy(classLoader, new InterceptorInvoker(target, interceptor), proxyClasses);
    }

    @Override
    public <T> T createInvokerProxy(ClassLoader classLoader, ObjectInvoker invoker, Class<?> ... proxyClasses) {
        return this.createProxy(classLoader, invoker, proxyClasses);
    }

    private <T> T createProxy(ClassLoader classLoader, ObjectInvoker invoker, Class<?> ... proxyClasses) {
        this.canProxy(proxyClasses);
        try {
            Class<?> dynamicUserType = PROXY_CLASS_CACHE.getProxyClass(classLoader, proxyClasses);
            InstanceCreator factory = (InstanceCreator)new ByteBuddy().subclass(InstanceCreator.class).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class))).intercept((Implementation)MethodDelegation.toConstructor(dynamicUserType)).make().load(classLoader).getLoaded().newInstance();
            Object ret = factory.makeInstance();
            ((ObjectInvokerAccessor)ret).setObjectInvoker(invoker);
            return (T)ret;
        }
        catch (Exception e) {
            throw new ProxyCreatorException("Unable to instantiate proxy from generated proxy class.", e);
        }
    }

    private static class ProxyGenerator
    extends GeneratorTemplate {
        private ProxyGenerator() {
        }

        @Override
        public Class<?> generateProxyClass(ClassLoader classLoader, Class<?> ... proxyClasses) {
            Class dynamicUserType = new ByteBuddy().subclass(proxyClasses[0]).implement(new Type[]{ObjectInvokerAccessor.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class))).intercept((Implementation)MethodDelegation.to(DynamicDelegator.class)).make().load(this.getClass().getClassLoader()).getLoaded();
            return dynamicUserType;
        }
    }
}

