/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy;

import cn.wensiqun.asmsupport.utils.lang.ArrayUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.neoremind.dynamicproxy.util.Emptys;
import net.neoremind.dynamicproxy.util.KeyAndValue;
import net.neoremind.dynamicproxy.util.ReflectionUtil;

public class MethodSignature
implements Serializable {
    private static final long serialVersionUID = 2236251542533774653L;
    private static final Map<Class<?>, Character> primitiveAbbreviations;
    private static final Map<Character, Class<?>> reverseAbbreviations;
    private final String internal;

    private static void appendTo(StringBuilder buf, Class<?> type) {
        if (type.isPrimitive()) {
            buf.append(primitiveAbbreviations.get(type));
        } else if (type.isArray()) {
            buf.append('[');
            MethodSignature.appendTo(buf, type.getComponentType());
        } else {
            buf.append('L').append(type.getName().replace('.', '/')).append(';');
        }
    }

    private static KeyAndValue<String, Class<?>[]> parse(String internal) {
        SignaturePosition pos = new SignaturePosition();
        int lparen = internal.indexOf(40, pos.getIndex());
        String name = internal.substring(0, lparen).trim();
        pos.setIndex(lparen + 1);
        ArrayList params = Lists.newArrayList();
        while (pos.getIndex() < internal.length()) {
            char c = internal.charAt(pos.getIndex());
            if (Character.isWhitespace(c)) {
                pos.next();
                continue;
            }
            Character k = Character.valueOf(c);
            if (reverseAbbreviations.containsKey(k)) {
                params.add(reverseAbbreviations.get(k));
                pos.next();
                continue;
            }
            if (')' == c) {
                pos.next();
                break;
            }
            try {
                params.add(MethodSignature.parseType(internal, pos));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Method signature \"%s\" references unknown type", internal), e);
            }
        }
        return new KeyAndValue<String, Class<?>[]>(name, params.toArray(Emptys.EMPTY_CLASS_ARRAY));
    }

    private static Class<?> parseType(String internal, SignaturePosition pos) throws ClassNotFoundException {
        int here = pos.getIndex();
        char c = internal.charAt(here);
        switch (c) {
            case '[': {
                pos.next();
                Class<?> componentType = MethodSignature.parseType(internal, pos);
                return Array.newInstance(componentType, 0).getClass();
            }
            case 'L': {
                pos.next();
                int type = pos.getIndex();
                int semi = internal.indexOf(59, type);
                String className = internal.substring(type, semi).replace('/', '.');
                pos.setIndex(semi + 1);
                return Class.forName(className);
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected character at index %d of method signature \"%s\"", here, internal));
    }

    public MethodSignature(Method method) {
        StringBuilder buf = new StringBuilder(method.getName()).append('(');
        for (Class<?> p : method.getParameterTypes()) {
            MethodSignature.appendTo(buf, p);
        }
        buf.append(')');
        this.internal = buf.toString();
    }

    public static String getName(String className, String methodName, Class<?>[] parameterTypes) {
        StringBuilder buf = new StringBuilder(className).append(".").append(methodName).append('(');
        if (ArrayUtils.isNotEmpty((Object[])parameterTypes)) {
            for (Class<?> p : parameterTypes) {
                buf.append(p.getName()).append(",");
            }
        }
        buf.append(')');
        return buf.toString();
    }

    public Method toMethod(Class<?> type) {
        KeyAndValue<String, Class<?>[]> info = MethodSignature.parse(this.internal);
        return ReflectionUtil.getMethod(type, info.getKey(), info.getValue());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        MethodSignature other = (MethodSignature)o;
        return other.internal.equals(this.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    public String toString() {
        return this.internal;
    }

    static {
        HashMap map = Maps.newHashMap();
        map.put(Boolean.TYPE, Character.valueOf('Z'));
        map.put(Byte.TYPE, Character.valueOf('B'));
        map.put(Short.TYPE, Character.valueOf('S'));
        map.put(Integer.TYPE, Character.valueOf('I'));
        map.put(Character.TYPE, Character.valueOf('C'));
        map.put(Long.TYPE, Character.valueOf('J'));
        map.put(Float.TYPE, Character.valueOf('F'));
        map.put(Double.TYPE, Character.valueOf('D'));
        map.put(Void.TYPE, Character.valueOf('V'));
        HashMap reverseMap = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry entry : map.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        primitiveAbbreviations = Collections.unmodifiableMap(map);
        reverseAbbreviations = Collections.unmodifiableMap(reverseMap);
    }

    private static class SignaturePosition
    extends ParsePosition {
        SignaturePosition() {
            super(0);
        }

        SignaturePosition next() {
            return this.plus(1);
        }

        SignaturePosition plus(int addend) {
            this.setIndex(this.getIndex() + addend);
            return this;
        }
    }
}

