/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.random.string;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.moznion.random.string.RandomLetterPicker;
import net.moznion.random.string.RandomLetterPickers;
import net.moznion.random.string.RegexNormalizer;
import net.moznion.random.string.UserDefinedLetterPickerScanner;

public class RandomStringGenerator {
    private int numOfUpperLimit;
    private final Map<String, RandomLetterPicker> userDefinedPickers;
    private final Random random;
    private final RandomLetterPickers pickers;
    private static final int DEFAULT_NUM_OF_UPPER_LIMIT = 10;

    public RandomStringGenerator() {
        this(new Random(), 10);
    }

    public RandomStringGenerator(int numOfUpperLimit) {
        this(new Random(), numOfUpperLimit);
    }

    public RandomStringGenerator(Random random) {
        this(random, 10);
    }

    public RandomStringGenerator(Random random, int numOfUpperLimit) {
        this.numOfUpperLimit = numOfUpperLimit;
        this.random = random;
        this.userDefinedPickers = new HashMap<String, RandomLetterPicker>();
        this.pickers = new RandomLetterPickers(this.random);
    }

    public String generateFromPattern(String pattern) {
        return Arrays.stream(pattern.split("")).map(patternCharacter -> {
            RandomLetterPicker picker;
            switch (patternCharacter) {
                case "c": {
                    picker = this.pickers.getLowerCase();
                    break;
                }
                case "C": {
                    picker = this.pickers.getUpperCase();
                    break;
                }
                case "n": {
                    picker = this.pickers.getDigit();
                    break;
                }
                case "!": {
                    picker = this.pickers.getSymbol();
                    break;
                }
                case ".": {
                    picker = this.pickers.getAny();
                    break;
                }
                case "s": {
                    picker = this.pickers.getSalt();
                    break;
                }
                case "b": {
                    picker = this.pickers.getBinary();
                    break;
                }
                default: {
                    throw new RuntimeException("Detected invalid pattern character: " + patternCharacter);
                }
            }
            return picker.pickRandomLetter();
        }).collect(Collectors.joining());
    }

    public String generateByRegex(String regex) {
        String expanded = new RegexNormalizer(this.numOfUpperLimit, this.random).normalizeQuantifiers(regex);
        String[] regexCharacters = expanded.split("");
        int length = regexCharacters.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int j;
            String nextCharacter;
            String character = regexCharacters[i];
            RandomLetterPicker picker = null;
            String candidateCharacter = null;
            block9 : switch (character) {
                case "\\": {
                    try {
                        character = regexCharacters[++i];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new RuntimeException("Detected invalid escape character");
                    }
                    switch (character) {
                        case "w": {
                            picker = this.pickers.getWord();
                            break block9;
                        }
                        case "d": {
                            picker = this.pickers.getDigit();
                            break block9;
                        }
                        case "W": {
                            picker = this.pickers.getNotWord();
                            break block9;
                        }
                        case "D": {
                            picker = this.pickers.getNotDigit();
                            break block9;
                        }
                        case "s": {
                            picker = this.pickers.getSpace();
                            break block9;
                        }
                        case "S": {
                            picker = this.pickers.getAny();
                            break block9;
                        }
                    }
                    candidateCharacter = character;
                    break;
                }
                case "[": {
                    try {
                        UserDefinedLetterPickerScanner.ScannedUserDefinedPicker scannedUserDefinedPicker = UserDefinedLetterPickerScanner.scan(regexCharacters, i);
                        String key = scannedUserDefinedPicker.getKey();
                        i = scannedUserDefinedPicker.getCursor();
                        if (this.userDefinedPickers.get(key) == null) {
                            RandomLetterPicker userDefinedPicker = RandomLetterPicker.constructByCharacterRange(scannedUserDefinedPicker.getBounds());
                            this.userDefinedPickers.put(key, userDefinedPicker);
                        }
                        picker = this.userDefinedPickers.get(key);
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new RuntimeException("Occurs parsing error");
                    }
                }
                case ".": {
                    picker = this.pickers.getAny();
                    break;
                }
                default: {
                    candidateCharacter = character;
                }
            }
            int repetitionNum = 1;
            if (i + 1 < length && (nextCharacter = regexCharacters[i + 1]).equals("{")) {
                int j2 = i + 1;
                StringBuilder sbForQuantifier = new StringBuilder();
                try {
                    while (!(nextCharacter = regexCharacters[++j2]).equals("}")) {
                        sbForQuantifier.append(nextCharacter);
                    }
                    try {
                        repetitionNum = Integer.parseInt(sbForQuantifier.toString(), 10);
                        i = j2;
                    }
                    catch (RuntimeException e) {}
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            if (picker != null) {
                for (j = 0; j < repetitionNum; ++j) {
                    sb.append(picker.pickRandomLetter());
                }
                continue;
            }
            if (candidateCharacter != null) {
                for (j = 0; j < repetitionNum; ++j) {
                    sb.append(candidateCharacter);
                }
                continue;
            }
            throw new RuntimeException("Occurs parsing error");
        }
        return sb.toString();
    }

    public int getNumOfUpperLimit() {
        return this.numOfUpperLimit;
    }

    public void setNumOfUpperLimit(int numOfUpperLimit) {
        this.numOfUpperLimit = numOfUpperLimit;
    }
}

