/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.primitive;

import java.util.Arrays;
import net.mintern.primitive.BooleanTimSort;
import net.mintern.primitive.ByteTimSort;
import net.mintern.primitive.CharTimSort;
import net.mintern.primitive.DoubleTimSort;
import net.mintern.primitive.FloatTimSort;
import net.mintern.primitive.IntTimSort;
import net.mintern.primitive.LongTimSort;
import net.mintern.primitive.ShortTimSort;
import net.mintern.primitive.comparators.BooleanComparator;
import net.mintern.primitive.comparators.ByteComparator;
import net.mintern.primitive.comparators.CharComparator;
import net.mintern.primitive.comparators.DoubleComparator;
import net.mintern.primitive.comparators.FloatComparator;
import net.mintern.primitive.comparators.IntComparator;
import net.mintern.primitive.comparators.LongComparator;
import net.mintern.primitive.comparators.ShortComparator;

public final class Primitive {
    public static void sort(boolean[] a) {
        Primitive.sort(a, 0, a.length);
    }

    public static void sort(boolean[] a, int fromIndex, int toIndex) {
        Primitive.checkBounds(a.length, fromIndex, toIndex);
        while (fromIndex < toIndex && !a[fromIndex]) {
            ++fromIndex;
        }
        if (fromIndex == toIndex) {
            return;
        }
        int nextFalse = fromIndex;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i]) continue;
            a[nextFalse] = false;
            a[i] = true;
            ++nextFalse;
        }
    }

    public static void sort(boolean[] a, BooleanComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(boolean[] a, int fromIndex, int toIndex, BooleanComparator c) {
        if (c == null) {
            Primitive.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            BooleanTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    public static void sort(byte[] a, ByteComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex, ByteComparator c) {
        if (c == null) {
            Arrays.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            ByteTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    public static void sort(char[] a, CharComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(char[] a, int fromIndex, int toIndex, CharComparator c) {
        if (c == null) {
            Arrays.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            CharTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    public static void sort(double[] a, DoubleComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(double[] a, int fromIndex, int toIndex, DoubleComparator c) {
        if (c == null) {
            Arrays.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            DoubleTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    public static void sort(float[] a, FloatComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(float[] a, int fromIndex, int toIndex, FloatComparator c) {
        if (c == null) {
            Arrays.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            FloatTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    public static void sort(int[] a, IntComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        if (c == null) {
            Arrays.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            IntTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    public static void sort(long[] a, LongComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(long[] a, int fromIndex, int toIndex, LongComparator c) {
        if (c == null) {
            Arrays.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            LongTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    public static void sort(short[] a, ShortComparator c) {
        Primitive.sort(a, 0, a.length, c);
    }

    public static void sort(short[] a, int fromIndex, int toIndex, ShortComparator c) {
        if (c == null) {
            Arrays.sort(a, fromIndex, toIndex);
        } else {
            Primitive.checkBounds(a.length, fromIndex, toIndex);
            ShortTimSort.sort(a, fromIndex, toIndex, c, null, 0, 0);
        }
    }

    private static void checkBounds(int len, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("fromIndex < 0");
        }
        if (toIndex > len) {
            throw new ArrayIndexOutOfBoundsException("toIndex > a.length");
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex");
        }
    }

    private Primitive() {
    }
}

