/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.filter;

import cn.hutool.json.JSONUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.web.filter.authz.RolesAuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.http.HttpStatus;

public class ShiroRoleFilter
extends RolesAuthorizationFilter {
    public ShiroRoleFilter(String unauthorizedUrl) {
        this.setUnauthorizedUrl(unauthorizedUrl);
    }

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        return super.isAccessAllowed(request, response, mappedValue);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (BasicUtil.isAjaxRequest(req)) {
            resp.setHeader("Access-Control-Allow-Origin", req.getHeader("Origin"));
            resp.setHeader("Access-Control-Allow-Credentials", "true");
            resp.setContentType("application/json; charset=utf-8");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            PrintWriter out = resp.getWriter();
            ResultData data = ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("\u672a\u68c0\u6d4b\u5230\u767b\u5f55\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            out.println(JSONUtil.toJsonStr((Object)data));
            out.flush();
            out.close();
        } else {
            String unauthorizedUrl = this.getUnauthorizedUrl();
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)unauthorizedUrl);
        }
        return false;
    }
}

