/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.aop;

import cn.hutool.core.date.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class SaveOrUpdateAop
extends BaseAop {
    @Pointcut(value="execution(* net.mingsoft..*Action.save(..))")
    public void save() {
    }

    @Pointcut(value="execution(* net.mingsoft..*Action.update(..))")
    public void update() {
    }

    @Before(value="save()")
    public void save(JoinPoint jp) {
        Date date = new Date();
        List<BaseEntity> baseEntities = this.extractBaseEntity(jp);
        ManagerEntity manager = BasicUtil.getManager();
        String managerId = manager != null ? manager.getId() : "";
        baseEntities.forEach(baseEntity -> {
            baseEntity.setCreateDate((Date)DateUtil.beginOfSecond((Date)date));
            baseEntity.setUpdateDate((Date)DateUtil.beginOfSecond((Date)date));
            baseEntity.setCreateBy(managerId);
        });
    }

    @Before(value="update()")
    public void update(JoinPoint jp) {
        List<BaseEntity> baseEntities = this.extractBaseEntity(jp);
        ManagerEntity manager = BasicUtil.getManager();
        String managerId = manager != null ? manager.getId() : "";
        baseEntities.forEach(baseEntity -> {
            baseEntity.setUpdateDate((Date)DateUtil.beginOfSecond((Date)new Date()));
            baseEntity.setUpdateBy(managerId);
        });
    }

    private List<BaseEntity> extractBaseEntity(JoinPoint jp) {
        ArrayList<BaseEntity> entities = new ArrayList<BaseEntity>();
        BaseEntity directEntity = this.getType(jp, BaseEntity.class, true);
        if (directEntity != null) {
            entities.add(directEntity);
            return entities;
        }
        Object jsonParam = this.getJsonParam(jp);
        if (jsonParam instanceof List) {
            List list = (List)jsonParam;
            list.forEach(item -> {
                if (item instanceof BaseEntity) {
                    BaseEntity baseEntity = (BaseEntity)item;
                    entities.add(baseEntity);
                }
            });
        }
        return entities;
    }
}

