/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.aop;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.config.MSProperties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
public class FileVerifyAop
extends BaseAop {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileVerifyAop.class);

    @Pointcut(value="execution(* net.mingsoft.basic.action.ManageFileAction.upload(..)) || execution(* net.mingsoft.basic.action.ManageFileAction.uploadTemplate(..))")
    public void uploadPointCut() {
    }

    @Around(value="uploadPointCut()")
    public Object uploadAop(ProceedingJoinPoint joinPoint) throws Throwable {
        UploadConfigBean bean = super.getType((JoinPoint)joinPoint, UploadConfigBean.class);
        ResultData resultData = this.prepareUpload(bean, false);
        if (resultData.isSuccess()) {
            return joinPoint.proceed();
        }
        return resultData;
    }

    @Around(value="execution(* net.mingsoft.basic.action.web.FileAction.upload(..))")
    public Object webUploadAop(ProceedingJoinPoint joinPoint) throws Throwable {
        UploadConfigBean bean = super.getType((JoinPoint)joinPoint, UploadConfigBean.class);
        ResultData resultData = this.prepareUpload(bean, true);
        if (resultData.isSuccess()) {
            return joinPoint.proceed();
        }
        return resultData;
    }

    protected ResultData prepareUpload(UploadConfigBean uploadConfigBean, boolean isWeb) throws Exception {
        String[] errorType;
        if (uploadConfigBean.getUploadPath() != null && (uploadConfigBean.getUploadPath().contains("../") || uploadConfigBean.getUploadPath().contains("..\\"))) {
            return ResultData.build().error("\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84\u9519\u8bef");
        }
        if (uploadConfigBean.getFile() == null) {
            return ResultData.build().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        MultipartFile file = uploadConfigBean.getFile();
        String uploadFileName = file.getOriginalFilename();
        if (FileNameUtil.containsInvalid((String)uploadFileName)) {
            return ResultData.build().error("\u975e\u6cd5\u6587\u4ef6\u540d\u683c\u5f0f!");
        }
        if (StringUtils.isBlank((CharSequence)uploadFileName) || StringUtils.isBlank((CharSequence)FileNameUtil.mainName((String)uploadFileName))) {
            return ResultData.build().error("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (uploadFileName.lastIndexOf(".") < 0) {
            this.LOG.info("\u6587\u4ef6\u540d\u9519\u8bef:{}", (Object)uploadFileName);
            return ResultData.build().error("\u6587\u4ef6\u540d\u9519\u8bef");
        }
        long maxFileSize = MSProperties.upload.multipart.maxFileSize;
        if (file.getSize() > maxFileSize * 1024L) {
            return ResultData.build().error("\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236");
        }
        if (StringUtils.isNotBlank((CharSequence)uploadConfigBean.getUploadPath()) && uploadConfigBean.getUploadPath().contains(".")) {
            return ResultData.build().error("\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84\u9519\u8bef");
        }
        String fileExt = FileNameUtil.extName((String)uploadFileName).toLowerCase();
        String mimeType = FileUtil.getSuffix((String)uploadFileName).toLowerCase();
        String uploadFileDenied = MSProperties.upload.denied;
        if (StringUtils.isBlank((CharSequence)uploadFileDenied)) {
            uploadFileDenied = "exe,jsp";
        }
        for (String errType : errorType = uploadFileDenied.split(",")) {
            if (mimeType.equalsIgnoreCase(errType)) {
                this.LOG.info("\u6587\u4ef6\u540e\u7f00\u88ab\u62d2\u7edd:{}", (Object)mimeType);
                return ResultData.build().error(StrUtil.format((CharSequence)"\u6587\u4ef6\u540e\u7f00\u88ab\u62d2\u7edd:{}", (Object[])new Object[]{mimeType}));
            }
            if (!fileExt.equalsIgnoreCase(errType)) continue;
            this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object)fileExt);
            return ResultData.build().error(StrUtil.format((CharSequence)"\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object[])new Object[]{mimeType}));
        }
        try {
            if ("zip".equalsIgnoreCase(mimeType) || "zip".equalsIgnoreCase(fileExt)) {
                this.checkZip(file, isWeb);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u6d41\u5904\u7406\u5f02\u5e38", (Throwable)e);
            return ResultData.build().error(e.getMessage());
        }
        return ResultData.build().success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkZip(MultipartFile multipartFile, boolean isWeb) {
        File tempFilePath = FileUtil.mkdir((String)(FileUtil.getTmpDirPath() + "/Zip" + IdUtil.simpleUUID()));
        File zipFile = FileUtil.file((String)(tempFilePath.getAbsolutePath() + "/" + IdUtil.simpleUUID() + ".zip"));
        try (InputStream inputStream = multipartFile.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)zipFile);
            try {
                ZipUtil.unzip((File)zipFile, (File)tempFilePath, (Charset)Charset.forName("GBK"));
            }
            catch (Exception e) {
                ZipUtil.unzip((File)zipFile, (File)tempFilePath, (Charset)StandardCharsets.UTF_8);
            }
            List files = FileUtil.loopFiles((File)tempFilePath);
            files.remove(zipFile);
            List deniedList = Arrays.stream(MSProperties.upload.denied.split(",")).map(String::toLowerCase).collect(Collectors.toList());
            for (File file : files) {
                String fileType = FileTypeUtil.getType((File)file).toLowerCase();
                String fileSuffixName = FileUtil.getSuffix((File)file);
                if (deniedList.contains(fileSuffixName)) {
                    throw new BusinessException(StrUtil.format((CharSequence)"\u538b\u7f29\u5305\u5185\u6587\u4ef6{}\u540e\u7f00{}\u7981\u6b62\u4e0a\u4f20", (Object[])new Object[]{file.getName(), fileSuffixName}));
                }
                if (!deniedList.contains(fileType)) continue;
                throw new BusinessException(StrUtil.format((CharSequence)"\u538b\u7f29\u5305\u5185\u6587\u4ef6{}\u7684\u7c7b\u578b{}\u7981\u6b62\u4e0a\u4f20", (Object[])new Object[]{file.getName(), fileType}));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.del((File)tempFilePath);
        }
    }
}

