/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.bean.RoleBean;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.entity.RoleEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u57fa\u7840\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/role"})
public class RoleAction
extends BaseAction {
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @Hidden
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"basic:role:view"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/role/index";
    }

    @Hidden
    @GetMapping(value={"/form"})
    @RequiresPermissions(value={"basic:role:view"})
    public String form(@ModelAttribute @Parameter(hidden=true) RoleEntity role, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        return "/basic/role/form";
    }

    @Operation(summary="\u67e5\u8be2\u89d2\u8272\u5217\u8868")
    @Parameters(value={@Parameter(name="roleName", description="\u89d2\u8272\u540d\u79f0", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) RoleEntity role, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        BasicUtil.startPage();
        List roleList = this.roleBiz.query(role);
        return ResultData.build().success((Object)new EUListBean(roleList, (int)BasicUtil.endPage(roleList).getTotal()));
    }

    @Operation(summary="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u6a21\u5757\u96c6\u5408")
    @Parameter(name="roleId", description="\u89d2\u8272ID", required=true, in=ParameterIn.PATH)
    @GetMapping(value={"/{roleId}/queryByRole"})
    @ResponseBody
    public ResultData queryByRole(@PathVariable @Parameter(hidden=true) int roleId, HttpServletResponse response) {
        List<ModelEntity> models = this.modelBiz.queryModelByRoleId(roleId);
        return ResultData.build().success(models);
    }

    @Operation(summary="\u67e5\u8be2\u6240\u6709\u89d2\u8272\u5217\u8868")
    @Parameters(value={@Parameter(name="roleName", description="\u89d2\u8272\u540d\u79f0", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/all"})
    @ResponseBody
    public ResultData all(@ModelAttribute @Parameter(hidden=true) RoleEntity role, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        BasicUtil.startPage();
        List roleList = this.roleBiz.query(role);
        return ResultData.build().success((Object)new EUListBean(roleList, (int)BasicUtil.endPage(roleList).getTotal()));
    }

    @Operation(summary="\u83b7\u53d6\u89d2\u8272")
    @Parameter(name="id", description="\u89d2\u8272ID", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"basic:role:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @Parameter(hidden=true) RoleEntity role, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)role.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("role.id")}));
        }
        RoleEntity _role = (RoleEntity)this.roleBiz.getEntity(Integer.parseInt(role.getId()));
        return ResultData.build().success((Object)_role);
    }

    @Operation(summary="\u4fdd\u5b58\u89d2\u8272\u5b9e\u4f53")
    @Parameters(value={@Parameter(name="roleName", description="\u89d2\u8272\u540d\u79f0", required=true, in=ParameterIn.QUERY), @Parameter(name="ids", description="\u529f\u80fd\u6743\u9650id", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u4fdd\u5b58\u89d2\u8272\u5b9e\u4f53", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/saveOrUpdateRole"})
    @ResponseBody
    @RequiresPermissions(value={"basic:role:save", "basic:role:update"}, logical=Logical.OR)
    public ResultData saveOrUpdateRole(@ModelAttribute @Parameter(hidden=true) RoleBean role, HttpServletResponse response, HttpServletRequest request) {
        RoleBean _role = new RoleBean();
        _role.setRoleName(role.getRoleName());
        if (StringUtils.isEmpty((CharSequence)role.getRoleName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("roleName")}));
        }
        if (!StringUtil.checkLength(role.getRoleName(), 1, 30)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("role.name"), "1", "30"}));
        }
        RoleBean roleBean = (RoleBean)((Object)this.roleBiz.getEntity(_role));
        if (StringUtils.isNotEmpty((CharSequence)role.getId())) {
            if (roleBean != null && !roleBean.getId().equals(role.getId())) {
                return ResultData.build().error(this.getResString("roleName.exist"));
            }
            role.setUpdateBy(BasicUtil.getManager().getId());
            role.setUpdateDate(new Date());
            role.setCreateBy(null);
            this.roleBiz.updateById((Object)role);
        } else {
            if (roleBean != null) {
                return ResultData.build().error(this.getResString("roleName.exist"));
            }
            role.setCreateBy(BasicUtil.getManager().getId());
            role.setCreateDate(new Date());
            this.roleBiz.save((Object)role);
            this.roleBiz.updateCache();
        }
        ArrayList<RoleModelEntity> roleModelList = new ArrayList<RoleModelEntity>();
        if (!StringUtils.isEmpty((CharSequence)role.getIds())) {
            for (String id : role.getIds().split(",")) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setRoleId(Integer.parseInt(role.getId()));
                roleModel.setModelId(Integer.parseInt(id));
                roleModelList.add(roleModel);
            }
            this.roleModelBiz.deleteByRoleId(Integer.parseInt(role.getId()));
            this.modelBiz.updateCache();
            this.roleModelBiz.saveBatch(roleModelList, roleModelList.size());
        } else {
            this.roleModelBiz.deleteByRoleId(Integer.parseInt(role.getId()));
        }
        this.roleBiz.updateCache();
        return ResultData.build().success((Object)role);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u89d2\u8272")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"basic:role:del"})
    @LogAnn(title="\u5220\u9664\u89d2\u8272", businessType=BusinessTypeEnum.DELETE)
    public ResultData delete(@RequestBody List<RoleEntity> roles, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity managerSession = BasicUtil.getManager();
        if (this.roleBiz.deleteRoleByRoles(roles, managerSession)) {
            return ResultData.build().success("\u5220\u9664\u6210\u529f", null);
        }
        return ResultData.build().success("\u5220\u9664\u6210\u529f\uff0c\u5df2\u8fc7\u6ee4\u5f53\u524d\u4e0d\u53ef\u5220\u9664\u89d2\u8272", null);
    }
}

