/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.strategy.IModelStrategy;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.ConfigUtil;
import net.mingsoft.config.MSProperties;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class BaseAction
extends net.mingsoft.base.action.BaseAction {
    @Autowired
    private IAppBiz appBiz;
    @Autowired
    private IModelStrategy modelStrategy;
    @Value(value="${ms.mwebsite:table:cms_category,cms_content,mdiy_dict,mdiy_page,role}")
    private String tables;

    protected String getResString(String key) {
        String str = "";
        try {
            str = super.getResString(key);
        }
        catch (MissingResourceException e) {
            str = this.getLocaleString(key, "net.mingsoft.basic.resources.resources");
        }
        return str;
    }

    protected boolean checkRandCode() {
        return this.checkRandCode(SessionConstEnum.CODE_SESSION.toString());
    }

    protected String decryptByAES(HttpServletRequest request, String str) {
        String _str = SecureUtil.aes((byte[])SecureUtil.md5((String)BasicUtil.getApp().getAppId()).substring(16).getBytes()).decryptStr(str);
        return _str;
    }

    protected String encryptByAES(HttpServletRequest request, String str) {
        String _str = SecureUtil.aes((byte[])SecureUtil.md5((String)BasicUtil.getApp().getAppId()).substring(16).getBytes()).encryptHex(str);
        return _str;
    }

    protected String getRandCode() {
        return (String)BasicUtil.getSession(SessionConstEnum.CODE_SESSION);
    }

    protected String redirectBack(boolean flag) {
        if (flag) {
            return "redirect:" + BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
        }
        return BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
    }

    protected boolean checkRandCode(String param) {
        boolean checkCode = ConfigUtil.getBoolean("\u540e\u53f0\u5f00\u53d1\u914d\u7f6e", "managerCheckCode", MSProperties.manager.checkCode);
        if (!checkCode) {
            return true;
        }
        String sessionCode = this.getRandCode();
        String requestCode = BasicUtil.getString(param);
        this.LOG.debug("session_code:" + sessionCode + " requestCode:" + requestCode);
        if (StrUtil.isBlank((CharSequence)sessionCode)) {
            return false;
        }
        if (sessionCode.equalsIgnoreCase(requestCode)) {
            BasicUtil.removeSession(SessionConstEnum.CODE_SESSION);
            return true;
        }
        return false;
    }

    @Deprecated
    protected void removeUrlParams(HttpServletRequest request, String[] fitlers) {
        request.setAttribute("params", (Object)BasicUtil.assemblyRequestUrlParams(fitlers));
    }

    protected boolean validated(String tableName, String fieldName, String fieldValue) {
        SqlInjectionUtil.filterContent((String[])new String[]{tableName, fieldName, fieldValue});
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(tableName).append(" WHERE ").append(fieldName).append(" = ?");
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        List tableNames = StrUtil.split((CharSequence)ConfigUtil.getString("\u7ad9\u7fa4\u914d\u7f6e", "siteTables", this.tables), (CharSequence)",");
        if (ObjectUtil.isNotNull((Object)((Object)websiteApp)) && tableNames.contains(tableName)) {
            sql.append(" AND ").append("APP_ID = ").append(websiteApp.getAppId());
        }
        List list = this.appBiz.queryForList(sql.toString(), new Object[]{fieldValue});
        return CollUtil.isNotEmpty((Collection)list);
    }

    protected boolean validated(String tableName, String fieldName, String fieldValue, String id, String idName) {
        List list;
        SqlInjectionUtil.filterContent((String[])new String[]{tableName, fieldName, fieldValue});
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(tableName).append(" WHERE ").append(fieldName).append(" = ?");
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        List tableNames = StrUtil.split((CharSequence)ConfigUtil.getString("\u7ad9\u7fa4\u914d\u7f6e", "siteTables", this.tables), (CharSequence)",");
        if (ObjectUtil.isNotNull((Object)((Object)websiteApp)) && tableNames.contains(tableName)) {
            sql.append(" AND ").append("APP_ID = ").append(websiteApp.getAppId());
        }
        if (CollUtil.isNotEmpty((Collection)(list = this.appBiz.queryForList(sql.toString(), new Object[]{fieldValue})))) {
            if (list.size() == 1) {
                CaseInsensitiveMap _map = new CaseInsensitiveMap((Map)list.get(0));
                return !id.equals(_map.get((Object)idName).toString());
            }
            return true;
        }
        return false;
    }

    protected boolean hasPermissions(String masterPermission, String permission) {
        return SecurityUtils.getSubject().isPermitted(masterPermission) || SecurityUtils.getSubject().isPermitted(permission);
    }
}

