/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import cn.hutool.json.JSONUtil;
import java.util.Map;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.ConfigUtil;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class SecretUtil {
    public static final String SECRET = "secret";
    public static final String MANAGER_ID = "managerId";
    public static final String PEOPLE_ID = "peopleId";

    public static void addSecretParam(Map param) {
        if (!SecretUtil.isEnableSecret()) {
            return;
        }
        param.put(SECRET, "");
        param.put(MANAGER_ID, "");
        param.put(PEOPLE_ID, "");
        ManagerEntity manager = BasicUtil.getManager();
        Object peopleSession = BasicUtil.getSession("people_session");
        JdbcTemplate jdbcTemplate = SpringUtil.getBean(JdbcTemplate.class);
        if (manager != null) {
            String managerSecret = (String)jdbcTemplate.queryForObject("SELECT _SECRET FROM MANAGER WHERE ID = ?", String.class, new Object[]{manager.getId()});
            param.put(SECRET, managerSecret);
            param.put(MANAGER_ID, manager.getId());
        }
        if (peopleSession != null) {
            Map map = (Map)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)peopleSession), Map.class);
            String id = map.get("id").toString();
            String peopleSecret = (String)jdbcTemplate.queryForObject("SELECT _SECRET FROM PEOPLE WHERE ID = ?", String.class, new Object[]{id});
            String secret = param.get(SECRET).toString();
            if (StringUtils.isNotBlank((CharSequence)secret)) {
                param.put(SECRET, secret + "," + peopleSecret);
            } else {
                param.put(SECRET, peopleSecret);
            }
            param.put(PEOPLE_ID, SecretUtil.getPeopleCreateBy(id));
        }
    }

    public static boolean isEnableSecret() {
        return ConfigUtil.getBoolean("\u5206\u4fdd\u914d\u7f6e", "secretEnable", false);
    }

    public static String getPeopleCreateBy(String id) {
        return "u_" + id;
    }
}

