/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.CityBean;
import net.mingsoft.basic.biz.ICityBiz;
import net.mingsoft.basic.entity.CityEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u524d\u7aef-\u57fa\u7840\u63a5\u53e3")
@Controller(value="webCityAction")
@RequestMapping(value={"/basic/city"})
public class CityAction
extends BaseAction {
    @Autowired
    private ICityBiz cityBiz;

    @Operation(summary="\u6839\u636eid\u67e5\u8be2\u4e0b\u4e00\u7ea7\u57ce\u5e02\u6570\u636e\u5217\u8868\u96c6\u5408")
    @Parameters(value={@Parameter(name="provinceId", description="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, in=ParameterIn.QUERY), @Parameter(name="cityId", description="\u5e02\u7ea7id", required=false, in=ParameterIn.QUERY), @Parameter(name="countyId", description="\u53bf\uff0f\u533a\u7ea7id", required=false, in=ParameterIn.QUERY), @Parameter(name="townId", description="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@Parameter(hidden=true) @ModelAttribute CityEntity city) {
        Map<String, Object> stringObjectMap = BasicUtil.assemblyRequestMap();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper((Object)city);
        if (MapUtil.isEmpty(stringObjectMap)) {
            List<CityEntity> cityList = this.cityBiz.queryProvinceAndName(city);
            return ResultData.build().success(cityList);
        }
        if (StringUtils.isNotBlank((CharSequence)MapUtil.getStr(stringObjectMap, (Object)"provinceId", null))) {
            wrapper.select(new SFunction[]{CityEntity::getCityId, CityEntity::getCityName});
            wrapper.groupBy(CityEntity::getCityId, new SFunction[]{CityEntity::getCityName});
        } else if (StringUtils.isNotBlank((CharSequence)MapUtil.getStr(stringObjectMap, (Object)"cityId", null))) {
            wrapper.select(new SFunction[]{CityEntity::getCountyId, CityEntity::getCountyName});
            wrapper.groupBy(CityEntity::getCountyId, new SFunction[]{CityEntity::getCountyName});
        } else if (StringUtils.isNotBlank((CharSequence)MapUtil.getStr(stringObjectMap, (Object)"countyId", null))) {
            wrapper.select(new SFunction[]{CityEntity::getTownId, CityEntity::getTownName});
            wrapper.groupBy(CityEntity::getTownId, new SFunction[]{CityEntity::getTownName});
        } else if (StringUtils.isNotBlank((CharSequence)MapUtil.getStr(stringObjectMap, (Object)"townId", null))) {
            wrapper.select(new SFunction[]{CityEntity::getVillageId, CityEntity::getVillageName});
            wrapper.groupBy(CityEntity::getVillageId, new SFunction[]{CityEntity::getVillageName});
        }
        List cityList = this.cityBiz.list((Wrapper)wrapper);
        return ResultData.build().success((Object)cityList);
    }

    @Operation(summary="\u83b7\u53d6\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @Parameter(name="id", description="\u57ce\u5e02\u4e3b\u952e\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @Parameter(hidden=true) CityEntity city, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)city.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        CityEntity _city = (CityEntity)this.cityBiz.getEntity(Integer.parseInt(city.getId()));
        return ResultData.build().success((Object)_city);
    }

    @Operation(summary="\u83b7\u53d6\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u6811\u5f62\u5217\u8868")
    @Parameters(value={@Parameter(name="level", description="\u7701\u5e02\u53bf\u5c42\u7ea7\uff0c\u9ed8\u8ba4\u4e3a3", required=false, in=ParameterIn.QUERY), @Parameter(name="type", description="\u7ed3\u6784\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4e3atree", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/query"})
    @ResponseBody
    @Deprecated
    public ResultData query(HttpServletResponse response, HttpServletRequest request) {
        int level = BasicUtil.getInt("level", 3);
        String type = BasicUtil.getString("type", "tree");
        List<CityBean> cityList = this.cityBiz.queryForTree(level, type);
        return ResultData.build().success(cityList);
    }
}

