/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.aop;

import com.mchange.v1.util.ArrayUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BaseAop {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    protected final <T> T getType(JoinPoint jp, Class<T> clazz) {
        Object[] objs;
        for (Object obj : objs = jp.getArgs()) {
            if (obj.getClass() != clazz) continue;
            return (T)obj;
        }
        return null;
    }

    protected final <T> T getType(JoinPoint jp, Class<T> clazz, boolean hasParent) {
        Object[] objs;
        for (Object obj : objs = jp.getArgs()) {
            if (obj.getClass() != clazz && obj.getClass().getSuperclass() != clazz) continue;
            return (T)obj;
        }
        return null;
    }

    protected final Object getJsonParam(JoinPoint jp) {
        Annotation[][] parameterAnnotations;
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        for (Annotation[] parameterAnnotation : parameterAnnotations = method.getParameterAnnotations()) {
            int paramIndex = ArrayUtils.indexOf((Object[])parameterAnnotations, (Object)parameterAnnotation);
            for (Annotation annotation : parameterAnnotation) {
                if (!(annotation instanceof RequestBody)) continue;
                return jp.getArgs()[paramIndex];
            }
        }
        return null;
    }

    protected final <T extends Annotation> T getAnnotation(JoinPoint jp, Class<T> an) {
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(an);
        }
        return null;
    }
}

