/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.exception;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.exception.BusinessException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

@ControllerAdvice
public class GlobalExceptionResolver
extends DefaultHandlerExceptionResolver {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @ExceptionHandler(value={Exception.class})
    public ModelAndView defaultErrorHandler(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String url = request.getServletPath();
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)sw, true));
        String msg = sw.toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int code = 200;
        map.put("url", url);
        map.put("msg", msg);
        map.put("exc", ex.getClass());
        map.put("cls", ex.getStackTrace()[0] + "");
        map.put("result", false);
        if (ex instanceof MissingServletRequestParameterException) {
            code = 400;
        }
        if (ex instanceof UnauthorizedException) {
            code = 403;
        }
        if (ex instanceof NoHandlerFoundException) {
            code = 404;
        }
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            code = 405;
        }
        if (ex instanceof BusinessException) {
            BusinessException be = (BusinessException)ex;
            map.put("msg", "\u4e1a\u52a1\u5f02\u5e38");
            map.put("bizCode", be.getBizCode());
            map.put("bizMsg", be.getMessage());
        }
        ex.printStackTrace();
        if (!(request.getHeader("accept") != null && request.getHeader("accept").indexOf("application/json") > -1 || request.getHeader("X-Requested-With") != null && request.getHeader("X-Requested-With").indexOf("XMLHttpRequest") > -1)) {
            if (map.get("code") == null) {
                map.put("code", 500);
                return new ModelAndView("/error/index", map);
            }
            ModelAndView mav = super.doResolveException(request, response, handler, ex);
            if (mav == null) {
                map.put("code", "500");
                return new ModelAndView("/error/index", map);
            }
            return mav;
        }
        if (ex instanceof BusinessException) {
            map.remove("url");
            map.remove("cls");
            map.remove("exc");
        }
        try {
            if (map.get("code") == null) {
                map.put("code", 500);
            }
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(JSONObject.toJSONString(map));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

