/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IBasicBiz;
import net.mingsoft.basic.biz.IBasicLogBiz;
import net.mingsoft.basic.constant.e.LogEnum;
import net.mingsoft.basic.entity.BasicEntity;
import net.mingsoft.basic.entity.BasicLogEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6587\u7ae0\u89e3\u6790\u5668\u63a5\u53e3")
@Controller(value="webBasicAction")
@RequestMapping(value={"/basic/"})
public class BasicAction
extends BaseAction {
    @Autowired
    private IBasicBiz basicBiz;
    @Autowired
    private IBasicLogBiz basicLogBiz;

    @ApiOperation(value="\u66f4\u65b0\u6587\u7ae0\u70b9\u51fb\u6570")
    @ApiImplicitParam(name="basicId", value="\u6587\u7ae0\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{basicId}/hit"})
    @ResponseBody
    public void hit(@PathVariable @ApiIgnore int basicId, HttpServletRequest request, HttpServletResponse response) {
        if (basicId <= 0) {
            this.outString(response, "document.write(0)");
            return;
        }
        BasicEntity basic = (BasicEntity)this.basicBiz.getEntity(basicId);
        if (basic == null) {
            this.outString(response, "document.write(0)");
            return;
        }
        int appId = BasicUtil.getAppId();
        if (basic.getBasicAppId() != appId) {
            this.outString(response, "document.write(0)");
            return;
        }
        boolean isShow = BasicUtil.getBoolean("isShow");
        if (isShow) {
            this.outString(response, "document.write(" + basic.getBasicHit() + ")");
            return;
        }
        BasicLogEntity basicLog = new BasicLogEntity();
        basicLog.setBasicLogAppId(appId);
        basicLog.setBasicLogDatetime(new Date());
        basicLog.setBasicLogIp(BasicUtil.getIp());
        basicLog.setBasicLogBasicId(basicId);
        if (this.isMobileDevice(request)) {
            basicLog.setBasicLogIsMobile(LogEnum.MOBILE.toInt());
        }
        int isHit = this.basicLogBiz.count(basicLog);
        this.basicBiz.updateHit(basicId, basic.getBasicHit() + 1);
        this.basicLogBiz.saveEntity(basicLog);
        this.outString(response, "document.write(" + (basic.getBasicHit() + 1) + ")");
    }
}

